/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.icons.IconManager;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;

public class WindowManager {
    private IconManager iconManager = new IconManager(this);
    private final Screen gui;
    private List<Window> windows = new ArrayList<Window>();
    private List<Window> modalWindows = new ArrayList<Window>();
    private int mouseWheel = -1;

    public WindowManager(Screen gui) {
        this.gui = gui;
    }

    public Screen getGui() {
        return this.gui;
    }

    public IconManager getIconManager() {
        return this.iconManager;
    }

    public void clearFocus() {
        Stream.concat(this.windows.stream(), this.modalWindows.stream()).forEach(w -> w.setFocus(null));
    }

    public void setFocus(Widget<?> w) {
        this.clearFocus();
        Stream.concat(this.windows.stream(), this.modalWindows.stream()).filter(window -> window.isWidgetOnWindow(w)).findFirst().ifPresent(window -> window.setTextFocus(w));
    }

    public WindowManager addWindow(Window w) {
        this.windows.add(w);
        w.setWindowManager(this);
        return this;
    }

    public WindowManager addModalWindow(Window w) {
        this.modalWindows.add(w);
        w.setWindowManager(this);
        return this;
    }

    public Window createModalWindow(AbstractContainerWidget<?> topLevel) {
        Window w = new Window(this.gui, topLevel);
        this.addModalWindow(w);
        return w;
    }

    public void closeWindow(Window window) {
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        } else if (this.modalWindows.contains(window)) {
            this.modalWindows.remove(window);
        }
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public void draw() {
        this.mouseWheel = 0;
        this.windows.stream().forEach(w -> w.draw());
        this.modalWindows.stream().forEach(w -> w.draw());
        this.iconManager.draw(Minecraft.func_71410_x(), this.gui);
    }

    private Stream<Window> getInteractableWindows() {
        if (this.modalWindows.isEmpty()) {
            return this.windows.stream();
        }
        Window window = this.modalWindows.get(this.modalWindows.size() - 1);
        return Stream.builder().add(window).build();
    }

    public Stream<Window> getModalWindows() {
        return this.modalWindows.stream();
    }

    public void drawTooltips() {
        Minecraft mc = this.gui.getMinecraft();
        MouseHelper mouse = mc.field_71417_B;
        int mouseX = (int)mouse.func_198024_e();
        int mouseY = (int)mouse.func_198026_f();
        int x = mouseX * this.gui.width / mc.field_195558_d.func_198105_m();
        int y = this.gui.height - mouseY * this.gui.height / mc.field_195558_d.func_198083_n() - 1;
        this.getInteractableWindows().forEach(w -> {
            List<String> tooltips = w.getTooltips();
            if (tooltips != null) {
                GenericGuiContainer gui = (GenericGuiContainer)this.gui;
                gui.drawHoveringText(tooltips, w.getTooltipItems(), x - gui.getGuiLeft(), y - gui.getGuiTop(), gui.getMinecraft().field_71466_p);
            }
        });
        RenderHelper.func_74520_c();
    }

    public Optional<Widget<?>> findWidgetAtPosition(int x, int y) {
        Stream<Widget> s = this.windows.stream().map(w -> w.getWidgetAtPosition(x, y));
        return s.filter(Objects::nonNull).findFirst();
    }

    public void mouseClicked(int x, int y, int button) {
        if (!this.iconManager.isClickHoldToDrag() && this.iconManager.isDragging()) {
            if (button == 1) {
                this.iconManager.cancelDragging();
            } else {
                this.iconManager.stopDragging(x, y);
            }
            return;
        }
        this.getInteractableWindows().forEach(w -> w.mouseClicked(x, y, button));
    }

    public void handleMouseInput(int k) {
        this.getInteractableWindows().forEach(w -> w.handleMouseInput(k));
    }

    public void mouseReleased(int x, int y, int state) {
        if (this.iconManager.isClickHoldToDrag() && this.iconManager.isDragging()) {
            this.iconManager.stopDragging(x, y);
        }
        this.getInteractableWindows().forEach(w -> w.mouseMovedOrUp(x, y, state));
    }

    public boolean keyTyped(int keyCode, int scanCode) {
        return this.getInteractableWindows().allMatch(w -> !w.keyTyped(keyCode, scanCode));
    }
}

