/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.Alternative;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.DamageSourceProperties;
import net.minecraft.world.storage.loot.conditions.EntityHasProperty;
import net.minecraft.world.storage.loot.conditions.EntityHasScore;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.Inverted;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LocationCheck;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.conditions.TableBonus;
import net.minecraft.world.storage.loot.conditions.WeatherCheck;

public class LootConditionManager {
    private static final Map<ResourceLocation, ILootCondition.AbstractSerializer<?>> field_186642_a = Maps.newHashMap();
    private static final Map<Class<? extends ILootCondition>, ILootCondition.AbstractSerializer<?>> field_186643_b = Maps.newHashMap();

    public static <T extends ILootCondition> void func_186639_a(ILootCondition.AbstractSerializer<? extends T> abstractSerializer) {
        ResourceLocation resourceLocation = abstractSerializer.func_186602_a();
        Class<T> \u26032 = abstractSerializer.func_186604_b();
        if (field_186642_a.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Can't re-register item condition name " + resourceLocation);
        }
        if (field_186643_b.containsKey(\u26032)) {
            throw new IllegalArgumentException("Can't re-register item condition class " + \u26032.getName());
        }
        field_186642_a.put(resourceLocation, abstractSerializer);
        field_186643_b.put(\u26032, abstractSerializer);
    }

    public static ILootCondition.AbstractSerializer<?> func_186641_a(ResourceLocation resourceLocation) {
        ILootCondition.AbstractSerializer<?> abstractSerializer = field_186642_a.get(resourceLocation);
        if (abstractSerializer == null) {
            throw new IllegalArgumentException("Unknown loot item condition '" + resourceLocation + "'");
        }
        return abstractSerializer;
    }

    public static <T extends ILootCondition> ILootCondition.AbstractSerializer<T> func_186640_a(T t) {
        ILootCondition.AbstractSerializer<?> abstractSerializer = field_186643_b.get(t.getClass());
        if (abstractSerializer == null) {
            throw new IllegalArgumentException("Unknown loot item condition " + t);
        }
        return abstractSerializer;
    }

    public static <T> Predicate<T> func_216305_a(Predicate<T>[] predicateArray) {
        switch (predicateArray.length) {
            case 0: {
                return object -> true;
            }
            case 1: {
                return predicateArray[0];
            }
            case 2: {
                return predicateArray[0].and(predicateArray[1]);
            }
        }
        return object -> {
            for (Predicate predicate : predicateArray) {
                if (predicate.test(object)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> func_216306_b(Predicate<T>[] predicateArray) {
        switch (predicateArray.length) {
            case 0: {
                return object -> false;
            }
            case 1: {
                return predicateArray[0];
            }
            case 2: {
                return predicateArray[0].or(predicateArray[1]);
            }
        }
        return object -> {
            for (Predicate predicate : predicateArray) {
                if (!predicate.test(object)) continue;
                return true;
            }
            return false;
        };
    }

    static {
        LootConditionManager.func_186639_a(new Inverted.Serializer());
        LootConditionManager.func_186639_a(new Alternative.Serializer());
        LootConditionManager.func_186639_a(new RandomChance.Serializer());
        LootConditionManager.func_186639_a(new RandomChanceWithLooting.Serializer());
        LootConditionManager.func_186639_a(new EntityHasProperty.Serializer());
        LootConditionManager.func_186639_a(new KilledByPlayer.Serializer());
        LootConditionManager.func_186639_a(new EntityHasScore.Serializer());
        LootConditionManager.func_186639_a(new BlockStateProperty.Serializer());
        LootConditionManager.func_186639_a(new MatchTool.Serializer());
        LootConditionManager.func_186639_a(new TableBonus.Serializer());
        LootConditionManager.func_186639_a(new SurvivesExplosion.Serializer());
        LootConditionManager.func_186639_a(new DamageSourceProperties.Serializer());
        LootConditionManager.func_186639_a(new LocationCheck.Serializer());
        LootConditionManager.func_186639_a(new WeatherCheck.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<ILootCondition>,
    JsonSerializer<ILootCondition> {
        public ILootCondition deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "condition");
            ResourceLocation \u26032 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "condition"));
            try {
                ILootCondition.AbstractSerializer<?> abstractSerializer = LootConditionManager.func_186641_a(\u26032);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonSyntaxException("Unknown condition '" + \u26032 + "'");
            }
            return abstractSerializer.func_186603_b(jsonObject, jsonDeserializationContext);
        }

        public JsonElement serialize(ILootCondition iLootCondition, Type type, JsonSerializationContext jsonSerializationContext) {
            ILootCondition.AbstractSerializer<ILootCondition> abstractSerializer = LootConditionManager.func_186640_a(iLootCondition);
            JsonObject \u26032 = new JsonObject();
            \u26032.addProperty("condition", abstractSerializer.func_186602_a().toString());
            abstractSerializer.func_186605_a(\u26032, iLootCondition, jsonSerializationContext);
            return \u26032;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ILootCondition)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

