/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.login.server.SCustomPayloadLoginPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CEditBookPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CLockDifficultyPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CQueryEntityNBTPacket;
import net.minecraft.network.play.client.CQueryTileEntityNBTPacket;
import net.minecraft.network.play.client.CRecipeInfoPacket;
import net.minecraft.network.play.client.CRenameItemPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraft.network.play.client.CSelectTradePacket;
import net.minecraft.network.play.client.CSetDifficultyPacket;
import net.minecraft.network.play.client.CSpectatePacket;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateBeaconPacket;
import net.minecraft.network.play.client.CUpdateCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateJigsawBlockPacket;
import net.minecraft.network.play.client.CUpdateMinecartCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUpdateStructureBlockPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.SAdvancementInfoPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SCameraPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SCloseWindowPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.network.play.server.SCooldownPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SDisplayObjectivePacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityHeadLookPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SEntityPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SEntityTeleportPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SKeepAlivePacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.network.play.server.SMerchantOffersPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SOpenBookWindowPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SOpenSignMenuPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SPlaceGhostRecipePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerDiggingPacket;
import net.minecraft.network.play.server.SPlayerListHeaderFooterPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SPlayerLookPacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SQueryNBTResponsePacket;
import net.minecraft.network.play.server.SRecipeBookPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SScoreboardObjectivePacket;
import net.minecraft.network.play.server.SSelectAdvancementsTabPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnExperienceOrbPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.network.play.server.SSpawnPaintingPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.network.play.server.SStatisticsPacket;
import net.minecraft.network.play.server.SStopSoundPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.network.play.server.SUpdateChunkPositionPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.network.play.server.SUpdateScorePacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.network.play.server.SWindowItemsPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.network.status.client.CPingPacket;
import net.minecraft.network.status.client.CServerQueryPacket;
import net.minecraft.network.status.server.SPongPacket;
import net.minecraft.network.status.server.SServerInfoPacket;
import org.apache.logging.log4j.LogManager;

public enum ProtocolType {
    HANDSHAKING(-1){
        {
            this.func_179245_a(PacketDirection.SERVERBOUND, CHandshakePacket.class);
        }
    }
    ,
    PLAY(0){
        {
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnObjectPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnExperienceOrbPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnGlobalEntityPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnMobPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnPaintingPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnPlayerPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SAnimateHandPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SStatisticsPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SAnimateBlockBreakPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateTileEntityPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SBlockActionPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SChangeBlockPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateBossInfoPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SServerDifficultyPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SChatPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SMultiBlockChangePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, STabCompletePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCommandListPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SConfirmTransactionPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCloseWindowPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SWindowItemsPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SWindowPropertyPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSetSlotPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCooldownPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCustomPayloadPlayPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlaySoundPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SDisconnectPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityStatusPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SExplosionPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUnloadChunkPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SChangeGameStatePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SOpenHorseWindowPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SKeepAlivePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SChunkDataPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlaySoundEventPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnParticlePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateLightPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SJoinGamePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SMapDataPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SMerchantOffersPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityPacket.RelativeMovePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityPacket.MovePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityPacket.LookPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SMoveVehiclePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SOpenBookWindowPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SOpenWindowPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SOpenSignMenuPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlaceGhostRecipePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayerAbilitiesPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCombatPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayerListItemPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayerLookPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayerPositionLookPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SRecipeBookPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SDestroyEntitiesPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SRemoveEntityEffectPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSendResourcePackPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SRespawnPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityHeadLookPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSelectAdvancementsTabPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SWorldBorderPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCameraPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SHeldItemChangePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateChunkPositionPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateViewDistancePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SDisplayObjectivePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityMetadataPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SMountEntityPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityVelocityPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityEquipmentPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSetExperiencePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateHealthPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SScoreboardObjectivePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSetPassengersPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, STeamsPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateScorePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnPositionPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateTimePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, STitlePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SSpawnMovingSoundEffectPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlaySoundEffectPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SStopSoundPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayerListHeaderFooterPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SQueryNBTResponsePacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCollectItemPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityTeleportPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SAdvancementInfoPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEntityPropertiesPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayEntityEffectPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SUpdateRecipesPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, STagsListPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPlayerDiggingPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CConfirmTeleportPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CQueryTileEntityNBTPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CSetDifficultyPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CChatMessagePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CClientStatusPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CClientSettingsPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CTabCompletePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CConfirmTransactionPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CEnchantItemPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CClickWindowPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CCloseWindowPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CCustomPayloadPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CEditBookPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CQueryEntityNBTPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUseEntityPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CKeepAlivePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CLockDifficultyPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerPacket.PositionPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerPacket.PositionRotationPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerPacket.RotationPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CMoveVehiclePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CSteerBoatPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPickItemPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlaceRecipePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerAbilitiesPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerDiggingPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CEntityActionPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CInputPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CRecipeInfoPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CRenameItemPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CResourcePackStatusPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CSeenAdvancementsPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CSelectTradePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUpdateBeaconPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CHeldItemChangePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUpdateCommandBlockPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUpdateMinecartCommandBlockPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CCreativeInventoryActionPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUpdateJigsawBlockPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUpdateStructureBlockPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CUpdateSignPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CAnimateHandPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CSpectatePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerTryUseItemOnBlockPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPlayerTryUseItemPacket.class);
        }
    }
    ,
    STATUS(1){
        {
            this.func_179245_a(PacketDirection.SERVERBOUND, CServerQueryPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SServerInfoPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CPingPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SPongPacket.class);
        }
    }
    ,
    LOGIN(2){
        {
            this.func_179245_a(PacketDirection.CLIENTBOUND, SDisconnectLoginPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEncryptionRequestPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SLoginSuccessPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SEnableCompressionPacket.class);
            this.func_179245_a(PacketDirection.CLIENTBOUND, SCustomPayloadLoginPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CLoginStartPacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CEncryptionResponsePacket.class);
            this.func_179245_a(PacketDirection.SERVERBOUND, CCustomPayloadLoginPacket.class);
        }
    };

    private static final ProtocolType[] field_150764_e;
    private static final Map<Class<? extends IPacket<?>>, ProtocolType> field_150761_f;
    private final int field_150762_g;
    private final Map<PacketDirection, BiMap<Integer, Class<? extends IPacket<?>>>> field_179247_h = Maps.newEnumMap(PacketDirection.class);

    private ProtocolType(int n2) {
        this.field_150762_g = n2;
    }

    protected ProtocolType func_179245_a(PacketDirection packetDirection, Class<? extends IPacket<?>> clazz) {
        HashBiMap hashBiMap = this.field_179247_h.get((Object)packetDirection);
        if (hashBiMap == null) {
            hashBiMap = HashBiMap.create();
            this.field_179247_h.put(packetDirection, (BiMap<Integer, Class<IPacket<?>>>)hashBiMap);
        }
        if (hashBiMap.containsValue(clazz)) {
            String string = (Object)((Object)packetDirection) + " packet " + clazz + " is already known to ID " + hashBiMap.inverse().get(clazz);
            LogManager.getLogger().fatal(string);
            throw new IllegalArgumentException(string);
        }
        hashBiMap.put((Object)hashBiMap.size(), clazz);
        return this;
    }

    public Integer func_179246_a(PacketDirection packetDirection, IPacket<?> iPacket) throws Exception {
        return (Integer)this.field_179247_h.get((Object)packetDirection).inverse().get(iPacket.getClass());
    }

    @Nullable
    public IPacket<?> func_179244_a(PacketDirection packetDirection, int n) throws IllegalAccessException, InstantiationException {
        Class clazz = (Class)this.field_179247_h.get((Object)packetDirection).get((Object)n);
        if (clazz == null) {
            return null;
        }
        return (IPacket)clazz.newInstance();
    }

    public int func_150759_c() {
        return this.field_150762_g;
    }

    public static ProtocolType func_150760_a(int n) {
        if (n < -1 || n > 2) {
            return null;
        }
        return field_150764_e[n - -1];
    }

    public static ProtocolType func_150752_a(IPacket<?> iPacket) {
        return field_150761_f.get(iPacket.getClass());
    }

    static {
        field_150764_e = new ProtocolType[4];
        field_150761_f = Maps.newHashMap();
        for (ProtocolType protocolType : ProtocolType.values()) {
            int n = protocolType.func_150759_c();
            if (n < -1 || n > 2) {
                throw new Error("Invalid protocol ID " + Integer.toString(n));
            }
            ProtocolType.field_150764_e[n - -1] = protocolType;
            for (PacketDirection packetDirection : protocolType.field_179247_h.keySet()) {
                for (Class clazz : protocolType.field_179247_h.get((Object)packetDirection).values()) {
                    if (field_150761_f.containsKey(clazz) && field_150761_f.get(clazz) != protocolType) {
                        throw new Error("Packet " + clazz + " is already assigned to protocol " + (Object)((Object)field_150761_f.get(clazz)) + " - can't reassign to " + (Object)((Object)protocolType));
                    }
                    try {
                        clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        throw new Error("Packet " + clazz + " fails instantiation checks! " + clazz);
                    }
                    field_150761_f.put(clazz, protocolType);
                }
            }
        }
    }
}

