/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.mojang.datafixers.DataFixUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.EyeOfEnderEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartCommandBlockEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityType<T extends Entity> {
    private static final Logger field_200731_aJ = LogManager.getLogger();
    public static final EntityType<AreaEffectCloudEntity> field_200788_b = EntityType.func_200712_a("area_effect_cloud", Builder.func_220322_a(AreaEffectCloudEntity::new, EntityClassification.MISC).func_220320_c().func_220321_a(6.0f, 0.5f));
    public static final EntityType<ArmorStandEntity> field_200789_c = EntityType.func_200712_a("armor_stand", Builder.func_220322_a(ArmorStandEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 1.975f));
    public static final EntityType<ArrowEntity> field_200790_d = EntityType.func_200712_a("arrow", Builder.func_220322_a(ArrowEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    public static final EntityType<BatEntity> field_200791_e = EntityType.func_200712_a("bat", Builder.func_220322_a(BatEntity::new, EntityClassification.AMBIENT).func_220321_a(0.5f, 0.9f));
    public static final EntityType<BlazeEntity> field_200792_f = EntityType.func_200712_a("blaze", Builder.func_220322_a(BlazeEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.6f, 1.8f));
    public static final EntityType<BoatEntity> field_200793_g = EntityType.func_200712_a("boat", Builder.func_220322_a(BoatEntity::new, EntityClassification.MISC).func_220321_a(1.375f, 0.5625f));
    public static final EntityType<CatEntity> field_220360_g = EntityType.func_200712_a("cat", Builder.func_220322_a(CatEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f));
    public static final EntityType<CaveSpiderEntity> field_200794_h = EntityType.func_200712_a("cave_spider", Builder.func_220322_a(CaveSpiderEntity::new, EntityClassification.MONSTER).func_220321_a(0.7f, 0.5f));
    public static final EntityType<ChickenEntity> field_200795_i = EntityType.func_200712_a("chicken", Builder.func_220322_a(ChickenEntity::new, EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f));
    public static final EntityType<CodEntity> field_203780_j = EntityType.func_200712_a("cod", Builder.func_220322_a(CodEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.5f, 0.3f));
    public static final EntityType<CowEntity> field_200796_j = EntityType.func_200712_a("cow", Builder.func_220322_a(CowEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f));
    public static final EntityType<CreeperEntity> field_200797_k = EntityType.func_200712_a("creeper", Builder.func_220322_a(CreeperEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.7f));
    public static final EntityType<DonkeyEntity> field_200798_l = EntityType.func_200712_a("donkey", Builder.func_220322_a(DonkeyEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.5f));
    public static final EntityType<DolphinEntity> field_205137_n = EntityType.func_200712_a("dolphin", Builder.func_220322_a(DolphinEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.9f, 0.6f));
    public static final EntityType<DragonFireballEntity> field_200799_m = EntityType.func_200712_a("dragon_fireball", Builder.func_220322_a(DragonFireballEntity::new, EntityClassification.MISC).func_220321_a(1.0f, 1.0f));
    public static final EntityType<DrownedEntity> field_204724_o = EntityType.func_200712_a("drowned", Builder.func_220322_a(DrownedEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<ElderGuardianEntity> field_200800_n = EntityType.func_200712_a("elder_guardian", Builder.func_220322_a(ElderGuardianEntity::new, EntityClassification.MONSTER).func_220321_a(1.9975f, 1.9975f));
    public static final EntityType<EnderCrystalEntity> field_200801_o = EntityType.func_200712_a("end_crystal", Builder.func_220322_a(EnderCrystalEntity::new, EntityClassification.MISC).func_220321_a(2.0f, 2.0f));
    public static final EntityType<EnderDragonEntity> field_200802_p = EntityType.func_200712_a("ender_dragon", Builder.func_220322_a(EnderDragonEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(16.0f, 8.0f));
    public static final EntityType<EndermanEntity> field_200803_q = EntityType.func_200712_a("enderman", Builder.func_220322_a(EndermanEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 2.9f));
    public static final EntityType<EndermiteEntity> field_200804_r = EntityType.func_200712_a("endermite", Builder.func_220322_a(EndermiteEntity::new, EntityClassification.MONSTER).func_220321_a(0.4f, 0.3f));
    public static final EntityType<EvokerFangsEntity> field_200805_s = EntityType.func_200712_a("evoker_fangs", Builder.func_220322_a(EvokerFangsEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.8f));
    public static final EntityType<EvokerEntity> field_200806_t = EntityType.func_200712_a("evoker", Builder.func_220322_a(EvokerEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<ExperienceOrbEntity> field_200807_u = EntityType.func_200712_a("experience_orb", Builder.func_220322_a(ExperienceOrbEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    public static final EntityType<EyeOfEnderEntity> field_200808_v = EntityType.func_200712_a("eye_of_ender", Builder.func_220322_a(EyeOfEnderEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<FallingBlockEntity> field_200809_w = EntityType.func_200712_a("falling_block", Builder.func_220322_a(FallingBlockEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.98f));
    public static final EntityType<FireworkRocketEntity> field_200810_x = EntityType.func_200712_a("firework_rocket", Builder.func_220322_a(FireworkRocketEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<FoxEntity> field_220356_B = EntityType.func_200712_a("fox", Builder.func_220322_a(FoxEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f));
    public static final EntityType<GhastEntity> field_200811_y = EntityType.func_200712_a("ghast", Builder.func_220322_a(GhastEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(4.0f, 4.0f));
    public static final EntityType<GiantEntity> field_200812_z = EntityType.func_200712_a("giant", Builder.func_220322_a(GiantEntity::new, EntityClassification.MONSTER).func_220321_a(3.6f, 12.0f));
    public static final EntityType<GuardianEntity> field_200761_A = EntityType.func_200712_a("guardian", Builder.func_220322_a(GuardianEntity::new, EntityClassification.MONSTER).func_220321_a(0.85f, 0.85f));
    public static final EntityType<HorseEntity> field_200762_B = EntityType.func_200712_a("horse", Builder.func_220322_a(HorseEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f));
    public static final EntityType<HuskEntity> field_200763_C = EntityType.func_200712_a("husk", Builder.func_220322_a(HuskEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<IllusionerEntity> field_200764_D = EntityType.func_200712_a("illusioner", Builder.func_220322_a(IllusionerEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<ItemEntity> field_200765_E = EntityType.func_200712_a("item", Builder.func_220322_a(ItemEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<ItemFrameEntity> field_200766_F = EntityType.func_200712_a("item_frame", Builder.func_220322_a(ItemFrameEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    public static final EntityType<FireballEntity> field_200767_G = EntityType.func_200712_a("fireball", Builder.func_220322_a(FireballEntity::new, EntityClassification.MISC).func_220321_a(1.0f, 1.0f));
    public static final EntityType<LeashKnotEntity> field_200768_H = EntityType.func_200712_a("leash_knot", Builder.func_220322_a(LeashKnotEntity::new, EntityClassification.MISC).func_200706_c().func_220321_a(0.5f, 0.5f));
    public static final EntityType<LlamaEntity> field_200769_I = EntityType.func_200712_a("llama", Builder.func_220322_a(LlamaEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.87f));
    public static final EntityType<LlamaSpitEntity> field_200770_J = EntityType.func_200712_a("llama_spit", Builder.func_220322_a(LlamaSpitEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<MagmaCubeEntity> field_200771_K = EntityType.func_200712_a("magma_cube", Builder.func_220322_a(MagmaCubeEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(2.04f, 2.04f));
    public static final EntityType<MinecartEntity> field_200772_L = EntityType.func_200712_a("minecart", Builder.func_220322_a(MinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<ChestMinecartEntity> field_200773_M = EntityType.func_200712_a("chest_minecart", Builder.func_220322_a(ChestMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<MinecartCommandBlockEntity> field_200774_N = EntityType.func_200712_a("command_block_minecart", Builder.func_220322_a(MinecartCommandBlockEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<FurnaceMinecartEntity> field_200775_O = EntityType.func_200712_a("furnace_minecart", Builder.func_220322_a(FurnaceMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<HopperMinecartEntity> field_200776_P = EntityType.func_200712_a("hopper_minecart", Builder.func_220322_a(HopperMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<SpawnerMinecartEntity> field_200777_Q = EntityType.func_200712_a("spawner_minecart", Builder.func_220322_a(SpawnerMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<TNTMinecartEntity> field_200778_R = EntityType.func_200712_a("tnt_minecart", Builder.func_220322_a(TNTMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f));
    public static final EntityType<MuleEntity> field_200779_S = EntityType.func_200712_a("mule", Builder.func_220322_a(MuleEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f));
    public static final EntityType<MooshroomEntity> field_200780_T = EntityType.func_200712_a("mooshroom", Builder.func_220322_a(MooshroomEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f));
    public static final EntityType<OcelotEntity> field_200781_U = EntityType.func_200712_a("ocelot", Builder.func_220322_a(OcelotEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f));
    public static final EntityType<PaintingEntity> field_200782_V = EntityType.func_200712_a("painting", Builder.func_220322_a(PaintingEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    public static final EntityType<PandaEntity> field_220353_aa = EntityType.func_200712_a("panda", Builder.func_220322_a(PandaEntity::new, EntityClassification.CREATURE).func_220321_a(1.3f, 1.25f));
    public static final EntityType<ParrotEntity> field_200783_W = EntityType.func_200712_a("parrot", Builder.func_220322_a(ParrotEntity::new, EntityClassification.CREATURE).func_220321_a(0.5f, 0.9f));
    public static final EntityType<PigEntity> field_200784_X = EntityType.func_200712_a("pig", Builder.func_220322_a(PigEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f));
    public static final EntityType<PufferfishEntity> field_203779_Z = EntityType.func_200712_a("pufferfish", Builder.func_220322_a(PufferfishEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.7f, 0.7f));
    public static final EntityType<ZombiePigmanEntity> field_200785_Y = EntityType.func_200712_a("zombie_pigman", Builder.func_220322_a(ZombiePigmanEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.6f, 1.95f));
    public static final EntityType<PolarBearEntity> field_200786_Z = EntityType.func_200712_a("polar_bear", Builder.func_220322_a(PolarBearEntity::new, EntityClassification.CREATURE).func_220321_a(1.4f, 1.4f));
    public static final EntityType<TNTEntity> field_200735_aa = EntityType.func_200712_a("tnt", Builder.func_220322_a(TNTEntity::new, EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f));
    public static final EntityType<RabbitEntity> field_200736_ab = EntityType.func_200712_a("rabbit", Builder.func_220322_a(RabbitEntity::new, EntityClassification.CREATURE).func_220321_a(0.4f, 0.5f));
    public static final EntityType<SalmonEntity> field_203778_ae = EntityType.func_200712_a("salmon", Builder.func_220322_a(SalmonEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.7f, 0.4f));
    public static final EntityType<SheepEntity> field_200737_ac = EntityType.func_200712_a("sheep", Builder.func_220322_a(SheepEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.3f));
    public static final EntityType<ShulkerEntity> field_200738_ad = EntityType.func_200712_a("shulker", Builder.func_220322_a(ShulkerEntity::new, EntityClassification.MONSTER).func_220320_c().func_225435_d().func_220321_a(1.0f, 1.0f));
    public static final EntityType<ShulkerBulletEntity> field_200739_ae = EntityType.func_200712_a("shulker_bullet", Builder.func_220322_a(ShulkerBulletEntity::new, EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f));
    public static final EntityType<SilverfishEntity> field_200740_af = EntityType.func_200712_a("silverfish", Builder.func_220322_a(SilverfishEntity::new, EntityClassification.MONSTER).func_220321_a(0.4f, 0.3f));
    public static final EntityType<SkeletonEntity> field_200741_ag = EntityType.func_200712_a("skeleton", Builder.func_220322_a(SkeletonEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f));
    public static final EntityType<SkeletonHorseEntity> field_200742_ah = EntityType.func_200712_a("skeleton_horse", Builder.func_220322_a(SkeletonHorseEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f));
    public static final EntityType<SlimeEntity> field_200743_ai = EntityType.func_200712_a("slime", Builder.func_220322_a(SlimeEntity::new, EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f));
    public static final EntityType<SmallFireballEntity> field_200744_aj = EntityType.func_200712_a("small_fireball", Builder.func_220322_a(SmallFireballEntity::new, EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f));
    public static final EntityType<SnowGolemEntity> field_200745_ak = EntityType.func_200712_a("snow_golem", Builder.func_220322_a(SnowGolemEntity::new, EntityClassification.MISC).func_220321_a(0.7f, 1.9f));
    public static final EntityType<SnowballEntity> field_200746_al = EntityType.func_200712_a("snowball", Builder.func_220322_a(SnowballEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<SpectralArrowEntity> field_200747_am = EntityType.func_200712_a("spectral_arrow", Builder.func_220322_a(SpectralArrowEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    public static final EntityType<SpiderEntity> field_200748_an = EntityType.func_200712_a("spider", Builder.func_220322_a(SpiderEntity::new, EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f));
    public static final EntityType<SquidEntity> field_200749_ao = EntityType.func_200712_a("squid", Builder.func_220322_a(SquidEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.8f, 0.8f));
    public static final EntityType<StrayEntity> field_200750_ap = EntityType.func_200712_a("stray", Builder.func_220322_a(StrayEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f));
    public static final EntityType<TraderLlamaEntity> field_220354_ax = EntityType.func_200712_a("trader_llama", Builder.func_220322_a(TraderLlamaEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.87f));
    public static final EntityType<TropicalFishEntity> field_204262_at = EntityType.func_200712_a("tropical_fish", Builder.func_220322_a(TropicalFishEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.5f, 0.4f));
    public static final EntityType<TurtleEntity> field_203099_aq = EntityType.func_200712_a("turtle", Builder.func_220322_a(TurtleEntity::new, EntityClassification.CREATURE).func_220321_a(1.2f, 0.4f));
    public static final EntityType<EggEntity> field_200751_aq = EntityType.func_200712_a("egg", Builder.func_220322_a(EggEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<EnderPearlEntity> field_200752_ar = EntityType.func_200712_a("ender_pearl", Builder.func_220322_a(EnderPearlEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<ExperienceBottleEntity> field_200753_as = EntityType.func_200712_a("experience_bottle", Builder.func_220322_a(ExperienceBottleEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<PotionEntity> field_200754_at = EntityType.func_200712_a("potion", Builder.func_220322_a(PotionEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final EntityType<TridentEntity> field_203098_aL = EntityType.func_200712_a("trident", Builder.func_220322_a(TridentEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    public static final EntityType<VexEntity> field_200755_au = EntityType.func_200712_a("vex", Builder.func_220322_a(VexEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.4f, 0.8f));
    public static final EntityType<VillagerEntity> field_200756_av = EntityType.func_200712_a("villager", Builder.func_220322_a(VillagerEntity::new, EntityClassification.MISC).func_220321_a(0.6f, 1.95f));
    public static final EntityType<IronGolemEntity> field_200757_aw = EntityType.func_200712_a("iron_golem", Builder.func_220322_a(IronGolemEntity::new, EntityClassification.MISC).func_220321_a(1.4f, 2.7f));
    public static final EntityType<VindicatorEntity> field_200758_ax = EntityType.func_200712_a("vindicator", Builder.func_220322_a(VindicatorEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<PillagerEntity> field_220350_aJ = EntityType.func_200712_a("pillager", Builder.func_220322_a(PillagerEntity::new, EntityClassification.MONSTER).func_225435_d().func_220321_a(0.6f, 1.95f));
    public static final EntityType<WanderingTraderEntity> field_220351_aK = EntityType.func_200712_a("wandering_trader", Builder.func_220322_a(WanderingTraderEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f));
    public static final EntityType<WitchEntity> field_200759_ay = EntityType.func_200712_a("witch", Builder.func_220322_a(WitchEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<WitherEntity> field_200760_az = EntityType.func_200712_a("wither", Builder.func_220322_a(WitherEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.9f, 3.5f));
    public static final EntityType<WitherSkeletonEntity> field_200722_aA = EntityType.func_200712_a("wither_skeleton", Builder.func_220322_a(WitherSkeletonEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.7f, 2.4f));
    public static final EntityType<WitherSkullEntity> field_200723_aB = EntityType.func_200712_a("wither_skull", Builder.func_220322_a(WitherSkullEntity::new, EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f));
    public static final EntityType<WolfEntity> field_200724_aC = EntityType.func_200712_a("wolf", Builder.func_220322_a(WolfEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f));
    public static final EntityType<ZombieEntity> field_200725_aD = EntityType.func_200712_a("zombie", Builder.func_220322_a(ZombieEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<ZombieHorseEntity> field_200726_aE = EntityType.func_200712_a("zombie_horse", Builder.func_220322_a(ZombieHorseEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f));
    public static final EntityType<ZombieVillagerEntity> field_200727_aF = EntityType.func_200712_a("zombie_villager", Builder.func_220322_a(ZombieVillagerEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<PhantomEntity> field_203097_aH = EntityType.func_200712_a("phantom", Builder.func_220322_a(PhantomEntity::new, EntityClassification.MONSTER).func_220321_a(0.9f, 0.5f));
    public static final EntityType<RavagerEntity> field_220352_aU = EntityType.func_200712_a("ravager", Builder.func_220322_a(RavagerEntity::new, EntityClassification.MONSTER).func_220321_a(1.95f, 2.2f));
    public static final EntityType<LightningBoltEntity> field_200728_aG = EntityType.func_200712_a("lightning_bolt", Builder.func_220319_a(EntityClassification.MISC).func_200706_c().func_220321_a(0.0f, 0.0f));
    public static final EntityType<PlayerEntity> field_200729_aH = EntityType.func_200712_a("player", Builder.func_220319_a(EntityClassification.MISC).func_200706_c().func_200705_b().func_220321_a(0.6f, 1.8f));
    public static final EntityType<FishingBobberEntity> field_200730_aI = EntityType.func_200712_a("fishing_bobber", Builder.func_220319_a(EntityClassification.MISC).func_200706_c().func_200705_b().func_220321_a(0.25f, 0.25f));
    private final IFactory<T> field_200732_aK;
    private final EntityClassification field_220355_ba;
    private final boolean field_200733_aL;
    private final boolean field_200734_aM;
    private final boolean field_220357_bd;
    private final boolean field_225438_be;
    @Nullable
    private String field_210762_aX;
    @Nullable
    private ITextComponent field_212547_aX;
    @Nullable
    private ResourceLocation field_220358_bg;
    private final EntitySize field_220359_bi;

    private static <T extends Entity> EntityType<T> func_200712_a(String string, Builder<T> builder) {
        return Registry.func_218325_a(Registry.field_212629_r, string, builder.func_206830_a(string));
    }

    public static ResourceLocation func_200718_a(EntityType<?> entityType) {
        return Registry.field_212629_r.func_177774_c(entityType);
    }

    public static Optional<EntityType<?>> func_220327_a(String string) {
        return Registry.field_212629_r.func_218349_b(ResourceLocation.func_208304_a(string));
    }

    public EntityType(IFactory<T> iFactory, EntityClassification entityClassification, boolean bl, boolean bl2, boolean bl3, boolean bl4, EntitySize entitySize) {
        this.field_200732_aK = iFactory;
        this.field_220355_ba = entityClassification;
        this.field_225438_be = bl4;
        this.field_200733_aL = bl;
        this.field_200734_aM = bl2;
        this.field_220357_bd = bl3;
        this.field_220359_bi = entitySize;
    }

    @Nullable
    public Entity func_220331_a(World world, @Nullable ItemStack itemStack, @Nullable PlayerEntity playerEntity, BlockPos blockPos, SpawnReason spawnReason, boolean bl, boolean bl2) {
        return this.func_220342_a(world, itemStack == null ? null : itemStack.func_77978_p(), itemStack != null && itemStack.func_82837_s() ? itemStack.func_200301_q() : null, playerEntity, blockPos, spawnReason, bl, bl2);
    }

    @Nullable
    public T func_220342_a(World world, @Nullable CompoundNBT compoundNBT, @Nullable ITextComponent iTextComponent, @Nullable PlayerEntity playerEntity, BlockPos blockPos, SpawnReason spawnReason, boolean bl, boolean bl2) {
        T t = this.func_220349_b(world, compoundNBT, iTextComponent, playerEntity, blockPos, spawnReason, bl, bl2);
        world.func_217376_c((Entity)t);
        return t;
    }

    @Nullable
    public T func_220349_b(World world, @Nullable CompoundNBT compoundNBT, @Nullable ITextComponent iTextComponent2, @Nullable PlayerEntity playerEntity, BlockPos blockPos, SpawnReason spawnReason, boolean bl, boolean bl2) {
        ITextComponent iTextComponent2;
        double d;
        T t = this.func_200721_a(world);
        if (t == null) {
            return null;
        }
        if (bl) {
            ((Entity)t).func_70107_b((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o() + 1, (double)blockPos.func_177952_p() + 0.5);
            d = EntityType.func_208051_a(world, blockPos, bl2, ((Entity)t).func_174813_aQ());
        } else {
            d = 0.0;
        }
        ((Entity)t).func_70012_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + d, (double)blockPos.func_177952_p() + 0.5, MathHelper.func_76142_g(world.field_73012_v.nextFloat() * 360.0f), 0.0f);
        if (t instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)t;
            mobEntity.field_70759_as = mobEntity.field_70177_z;
            mobEntity.field_70761_aq = mobEntity.field_70177_z;
            mobEntity.func_213386_a(world, world.func_175649_E(new BlockPos(mobEntity)), spawnReason, null, compoundNBT);
            mobEntity.func_70642_aH();
        }
        if (iTextComponent2 != null && t instanceof LivingEntity) {
            ((Entity)t).func_200203_b(iTextComponent2);
        }
        EntityType.func_208048_a(world, playerEntity, t, compoundNBT);
        return t;
    }

    protected static double func_208051_a(IWorldReader iWorldReader, BlockPos blockPos, boolean bl, AxisAlignedBB axisAlignedBB) {
        \u2603 = new AxisAlignedBB(blockPos);
        if (bl) {
            \u2603 = \u2603.func_72321_a(0.0, -1.0, 0.0);
        }
        Stream<VoxelShape> stream = iWorldReader.func_217352_b(null, \u2603, Collections.emptySet());
        return 1.0 + VoxelShapes.func_212437_a(Direction.Axis.Y, axisAlignedBB, stream, bl ? -2.0 : -1.0);
    }

    public static void func_208048_a(World world, @Nullable PlayerEntity playerEntity, @Nullable Entity entity, @Nullable CompoundNBT compoundNBT) {
        if (compoundNBT == null || !compoundNBT.func_150297_b("EntityTag", 10)) {
            return;
        }
        MinecraftServer minecraftServer = world.func_73046_m();
        if (minecraftServer == null || entity == null) {
            return;
        }
        if (!(world.field_72995_K || !entity.func_184213_bq() || playerEntity != null && minecraftServer.func_184103_al().func_152596_g(playerEntity.func_146103_bH()))) {
            return;
        }
        CompoundNBT \u26032 = entity.func_189511_e(new CompoundNBT());
        UUID \u26033 = entity.func_110124_au();
        \u26032.func_197643_a(compoundNBT.func_74775_l("EntityTag"));
        entity.func_184221_a(\u26033);
        entity.func_70020_e(\u26032);
    }

    public boolean func_200715_a() {
        return this.field_200733_aL;
    }

    public boolean func_200720_b() {
        return this.field_200734_aM;
    }

    public boolean func_220338_c() {
        return this.field_220357_bd;
    }

    public boolean func_225437_d() {
        return this.field_225438_be;
    }

    public EntityClassification func_220339_d() {
        return this.field_220355_ba;
    }

    public String func_210760_d() {
        if (this.field_210762_aX == null) {
            this.field_210762_aX = Util.func_200697_a("entity", Registry.field_212629_r.func_177774_c(this));
        }
        return this.field_210762_aX;
    }

    public ITextComponent func_212546_e() {
        if (this.field_212547_aX == null) {
            this.field_212547_aX = new TranslationTextComponent(this.func_210760_d(), new Object[0]);
        }
        return this.field_212547_aX;
    }

    public ResourceLocation func_220348_g() {
        if (this.field_220358_bg == null) {
            ResourceLocation resourceLocation = Registry.field_212629_r.func_177774_c(this);
            this.field_220358_bg = new ResourceLocation(resourceLocation.func_110624_b(), "entities/" + resourceLocation.func_110623_a());
        }
        return this.field_220358_bg;
    }

    public float func_220333_h() {
        return this.field_220359_bi.field_220315_a;
    }

    public float func_220344_i() {
        return this.field_220359_bi.field_220316_b;
    }

    @Nullable
    public T func_200721_a(World world) {
        return this.field_200732_aK.create(this, world);
    }

    public static Optional<Entity> func_220330_a(CompoundNBT compoundNBT, World world) {
        return Util.func_215077_a(EntityType.func_220347_a(compoundNBT).map(entityType -> entityType.func_200721_a(world)), entity -> entity.func_70020_e(compoundNBT), () -> field_200731_aJ.warn("Skipping Entity with id {}", (Object)compoundNBT.func_74779_i("id")));
    }

    public AxisAlignedBB func_220328_a(double d, double d2, double d3) {
        float f = this.func_220333_h() / 2.0f;
        return new AxisAlignedBB(d - (double)f, d2, d3 - (double)f, d + (double)f, d2 + (double)this.func_220344_i(), d3 + (double)f);
    }

    public EntitySize func_220334_j() {
        return this.field_220359_bi;
    }

    public static Optional<EntityType<?>> func_220347_a(CompoundNBT compoundNBT) {
        return Registry.field_212629_r.func_218349_b(new ResourceLocation(compoundNBT.func_74779_i("id")));
    }

    @Nullable
    public static Entity func_220335_a(CompoundNBT compoundNBT, World world, Function<Entity, Entity> function) {
        return EntityType.func_220343_b(compoundNBT, world).map(function).map(entity2 -> {
            Entity entity2;
            if (compoundNBT.func_150297_b("Passengers", 9)) {
                ListNBT listNBT = compoundNBT.func_150295_c("Passengers", 10);
                for (int i = 0; i < listNBT.size(); ++i) {
                    Entity entity3 = EntityType.func_220335_a(listNBT.func_150305_b(i), world, function);
                    if (entity3 == null) continue;
                    entity3.func_184205_a((Entity)entity2, true);
                }
            }
            return entity2;
        }).orElse(null);
    }

    private static Optional<Entity> func_220343_b(CompoundNBT compoundNBT, World world) {
        try {
            return EntityType.func_220330_a(compoundNBT, world);
        }
        catch (RuntimeException runtimeException) {
            field_200731_aJ.warn("Exception loading entity: ", (Throwable)runtimeException);
            return Optional.empty();
        }
    }

    public int func_220345_k() {
        if (this == field_200729_aH) {
            return 32;
        }
        if (this == field_200801_o) {
            return 16;
        }
        if (this == field_200802_p || this == field_200735_aa || this == field_200809_w || this == field_200766_F || this == field_200768_H || this == field_200782_V || this == field_200789_c || this == field_200807_u || this == field_200788_b || this == field_200805_s) {
            return 10;
        }
        if (this == field_200730_aI || this == field_200790_d || this == field_200747_am || this == field_203098_aL || this == field_200744_aj || this == field_200799_m || this == field_200767_G || this == field_200723_aB || this == field_200746_al || this == field_200770_J || this == field_200752_ar || this == field_200808_v || this == field_200751_aq || this == field_200754_at || this == field_200753_as || this == field_200810_x || this == field_200765_E) {
            return 4;
        }
        return 5;
    }

    public int func_220332_l() {
        if (this == field_200729_aH || this == field_200805_s) {
            return 2;
        }
        if (this == field_200808_v) {
            return 4;
        }
        if (this == field_200730_aI) {
            return 5;
        }
        if (this == field_200744_aj || this == field_200799_m || this == field_200767_G || this == field_200723_aB || this == field_200746_al || this == field_200770_J || this == field_200752_ar || this == field_200751_aq || this == field_200754_at || this == field_200753_as || this == field_200810_x || this == field_200735_aa) {
            return 10;
        }
        if (this == field_200790_d || this == field_200747_am || this == field_203098_aL || this == field_200765_E || this == field_200809_w || this == field_200807_u) {
            return 20;
        }
        if (this == field_200766_F || this == field_200768_H || this == field_200782_V || this == field_200788_b || this == field_200801_o) {
            return Integer.MAX_VALUE;
        }
        return 3;
    }

    public boolean func_220340_m() {
        return this != field_200729_aH && this != field_200770_J && this != field_200760_az && this != field_200791_e && this != field_200766_F && this != field_200768_H && this != field_200782_V && this != field_200801_o && this != field_200805_s;
    }

    public boolean func_220341_a(Tag<EntityType<?>> tag) {
        return tag.func_199685_a_(this);
    }

    public static interface IFactory<T extends Entity> {
        public T create(EntityType<T> var1, World var2);
    }

    public static class Builder<T extends Entity> {
        private final IFactory<T> field_200709_a;
        private final EntityClassification field_220324_b;
        private boolean field_200710_b = true;
        private boolean field_200711_c = true;
        private boolean field_220325_e;
        private boolean field_225436_f;
        private EntitySize field_220326_f = EntitySize.func_220314_b(0.6f, 1.8f);

        private Builder(IFactory<T> iFactory, EntityClassification entityClassification) {
            this.field_200709_a = iFactory;
            this.field_220324_b = entityClassification;
            this.field_225436_f = entityClassification == EntityClassification.CREATURE || entityClassification == EntityClassification.MISC;
        }

        public static <T extends Entity> Builder<T> func_220322_a(IFactory<T> iFactory, EntityClassification entityClassification) {
            return new Builder<T>(iFactory, entityClassification);
        }

        public static <T extends Entity> Builder<T> func_220319_a(EntityClassification entityClassification) {
            return new Builder<Entity>((entityType, world) -> null, entityClassification);
        }

        public Builder<T> func_220321_a(float f, float f2) {
            this.field_220326_f = EntitySize.func_220314_b(f, f2);
            return this;
        }

        public Builder<T> func_200705_b() {
            this.field_200711_c = false;
            return this;
        }

        public Builder<T> func_200706_c() {
            this.field_200710_b = false;
            return this;
        }

        public Builder<T> func_220320_c() {
            this.field_220325_e = true;
            return this;
        }

        public Builder<T> func_225435_d() {
            this.field_225436_f = true;
            return this;
        }

        public EntityType<T> func_206830_a(String string) {
            if (this.field_200710_b) {
                try {
                    DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)SharedConstants.func_215069_a().getWorldVersion())).getChoiceType(TypeReferences.field_211298_n, string);
                }
                catch (IllegalStateException illegalStateException) {
                    if (SharedConstants.field_206244_b) {
                        throw illegalStateException;
                    }
                    field_200731_aJ.warn("No data fixer registered for entity {}", (Object)string);
                }
            }
            return new EntityType<T>(this.field_200709_a, this.field_220324_b, this.field_200710_b, this.field_200711_c, this.field_220325_e, this.field_225436_f, this.field_220326_f);
        }
    }
}

