/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.net.packets;

import code.elix_x.excore.utils.net.packets.runnable.ClientRunnableMessageHandler;
import code.elix_x.excore.utils.net.packets.runnable.RunnableMessageHandler;
import code.elix_x.excore.utils.net.packets.runnable.ServerRunnableMessageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SmartNetworkWrapper {
    private final String name;
    private SimpleNetworkWrapper channel;
    private int nextPacketId = 0;
    private Map<Class<? extends IMessage>, Side> packetsReceivingSide = new HashMap<Class<? extends IMessage>, Side>();

    public SmartNetworkWrapper(String name) {
        this.name = name;
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel(name);
    }

    public String getName() {
        return this.name;
    }

    public SimpleNetworkWrapper getChannel() {
        return this.channel;
    }

    public int getNextPacketId() {
        return this.nextPacketId;
    }

    public Side getPacketReceivingSide(Class<? extends IMessage> clazz) {
        return this.packetsReceivingSide.get(clazz);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        this.channel.registerMessage(messageHandler, requestMessageType, this.nextPacketId, side);
        this.packetsReceivingSide.put(requestMessageType, side);
        ++this.nextPacketId;
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, Side side) {
        this.channel.registerMessage(messageHandler, requestMessageType, this.nextPacketId, side);
        this.packetsReceivingSide.put(requestMessageType, side);
        ++this.nextPacketId;
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Function<Pair<REQ, MessageContext>, Pair<Runnable, REPLY>> onReceive, Class<REQ> requestMessageType, Side side) {
        RunnableMessageHandler handler = new ServerRunnableMessageHandler<REQ, REPLY>(onReceive);
        if (side == Side.CLIENT && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            handler = new ClientRunnableMessageHandler<REQ, REPLY>(onReceive);
        }
        this.registerMessage(handler, requestMessageType, side);
    }

    public <REQ extends IMessage> void registerMessage1(final Function<Pair<REQ, MessageContext>, Runnable> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, IMessage>>(){

            @Override
            public Pair<Runnable, IMessage> apply(Pair<REQ, MessageContext> t) {
                return new ImmutablePair(onReceive.apply(t), null);
            }
        }, requestMessageType, side);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage2(final Function<REQ, Pair<Runnable, REPLY>> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, REPLY>>(){

            @Override
            public Pair<Runnable, REPLY> apply(Pair<REQ, MessageContext> t) {
                return (Pair)onReceive.apply(t.getKey());
            }
        }, requestMessageType, side);
    }

    public <REQ extends IMessage> void registerMessage3(final Function<REQ, Runnable> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, IMessage>>(){

            @Override
            public Pair<Runnable, IMessage> apply(Pair<REQ, MessageContext> t) {
                return new ImmutablePair(onReceive.apply(t.getKey()), null);
            }
        }, requestMessageType, side);
    }

    public <REQ extends IMessage> void registerMessage(final Runnable onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, IMessage>>(){

            @Override
            public Pair<Runnable, IMessage> apply(Pair<REQ, MessageContext> t) {
                return new ImmutablePair((Object)onReceive, null);
            }
        }, requestMessageType, side);
    }

    public void sendToAll(IMessage message) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channel.sendToAll(message);
        }
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channel.sendTo(message, player);
        }
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channel.sendToAllAround(message, point);
        }
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channel.sendToDimension(message, dimensionId);
        }
    }

    public void sendToServer(IMessage message) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.SERVER && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.channel.sendToServer(message);
        }
    }
}

