/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.nbt.mbt.encoders;

import code.elix_x.excore.utils.nbt.mbt.MBT;
import code.elix_x.excore.utils.nbt.mbt.MBTIgnore;
import code.elix_x.excore.utils.nbt.mbt.NBTEncoder;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class NBTClassEncoder
implements NBTEncoder<Object, NBTTagCompound> {
    public static final String CLASS = "#CLASS";
    public boolean encodeClass;
    public boolean encodeFinal;
    public boolean encodeStatic;
    public boolean encodeSuper;

    public NBTClassEncoder(boolean encodeClass, boolean encodeFinal, boolean encodeStatic, boolean encodeSuper) {
        this.encodeClass = encodeClass;
        this.encodeFinal = encodeFinal;
        this.encodeStatic = encodeStatic;
        this.encodeSuper = encodeSuper;
    }

    @Override
    public boolean canEncode(Object o) {
        return !o.getClass().isAnnotationPresent(MBTIgnore.class);
    }

    @Override
    public boolean canDecode(NBTBase nbt, Class clazz) {
        return nbt instanceof NBTTagCompound && !clazz.isAnnotationPresent(MBTIgnore.class);
    }

    @Override
    public NBTTagCompound toNBT(MBT mbt, Object t) {
        NBTTagCompound nbt = new NBTTagCompound();
        Class<Object> clazz = t.getClass();
        if (this.encodeClass) {
            nbt.func_74778_a(CLASS, clazz.getName());
        }
        while (clazz != null && clazz != Object.class) {
            if (!clazz.isAnnotationPresent(MBTIgnore.class)) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.isAnnotationPresent(MBTIgnore.class)) continue;
                    field.setAccessible(true);
                    if (!this.encodeFinal && Modifier.isFinal(field.getModifiers()) || !this.encodeStatic && Modifier.isStatic(field.getModifiers())) continue;
                    try {
                        nbt.func_74782_a(field.getName(), mbt.toNBT(field.get(t)));
                    }
                    catch (IllegalArgumentException e) {
                        Throwables.propagate((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        Throwables.propagate((Throwable)e);
                    }
                }
            }
            clazz = this.encodeSuper ? clazz.getSuperclass() : Object.class;
        }
        return nbt;
    }

    @Override
    public Object fromNBT(MBT mbt, NBTTagCompound nbt, Class clazz, Class ... tsclasses) {
        try {
            Constructor<?> constructor;
            if (this.encodeClass) {
                clazz = Class.forName(nbt.func_74779_i(CLASS));
            }
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            constructor.setAccessible(true);
            Object o = constructor.newInstance(new Object[0]);
            this.populate(mbt, nbt, o);
            return o;
        }
        catch (InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void populate(MBT mbt, NBTTagCompound nbt, Object o) {
        Class<Object> clazz = o.getClass();
        try {
            while (clazz != null && clazz != Object.class) {
                if (!clazz.isAnnotationPresent(MBTIgnore.class)) {
                    for (Field field : clazz.getDeclaredFields()) {
                        if (field.isAnnotationPresent(MBTIgnore.class)) continue;
                        field.setAccessible(true);
                        if (!nbt.func_74764_b(field.getName()) || !this.encodeStatic && Modifier.isStatic(field.getModifiers())) continue;
                        if (Modifier.isFinal(field.getModifiers())) {
                            if (!this.encodeFinal) continue;
                            Field modifiers = Field.class.getDeclaredField("modifiers");
                            modifiers.setAccessible(true);
                            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                            if (field.getGenericType() instanceof ParameterizedType) {
                                Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                                Object[] clas = new Class[]{};
                                Type[] typeArray = types;
                                int n = typeArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Type type = typeArray[i];
                                    if (!(type instanceof Class)) continue;
                                    clas = (Class[])ArrayUtils.add((Object[])clas, (Object)((Class)type));
                                }
                                field.set(o, mbt.fromNBT(nbt.func_74781_a(field.getName()), field.getType(), (Class[])clas));
                                continue;
                            }
                            field.set(o, mbt.fromNBT(nbt.func_74781_a(field.getName()), field.getType(), new Class[0]));
                            continue;
                        }
                        if (field.getGenericType() instanceof ParameterizedType) {
                            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                            Object[] clas = new Class[]{};
                            for (Type type : types) {
                                if (!(type instanceof Class)) continue;
                                clas = (Class[])ArrayUtils.add((Object[])clas, (Object)((Class)type));
                            }
                            field.set(o, mbt.fromNBT(nbt.func_74781_a(field.getName()), field.getType(), (Class[])clas));
                            continue;
                        }
                        field.set(o, mbt.fromNBT(nbt.func_74781_a(field.getName()), field.getType(), new Class[0]));
                    }
                }
                clazz = this.encodeSuper ? clazz.getSuperclass() : Object.class;
            }
        }
        catch (IllegalArgumentException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (SecurityException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

