/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excomms.color.RGBA;
import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.RectangularGuiElement;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.Rectangle;

public class IntegralSliderGuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
extends RectangularGuiElement<H> {
    protected static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    protected RGBA textColor = new RGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected int sliderWidth;
    protected int min;
    protected int max;
    protected double value;
    protected boolean displayValue;
    protected boolean dragged;

    public IntegralSliderGuiElement(String name, int xPos, int yPos, int width, int height, int borderX, int borderY, int sliderWidth, int min, int max, int defaultValue, boolean displayValue) {
        super(name, xPos, yPos, width, height, borderX, borderY);
        this.sliderWidth = sliderWidth;
        this.min = min;
        this.max = max;
        this.value = (double)(defaultValue - min) / (double)(max - min);
        this.displayValue = displayValue;
    }

    public int getValue() {
        return (int)(this.value * (double)(this.max - this.min) + (double)this.min);
    }

    protected void checkSliderValue() {
        this.value = Math.min(Math.max(this.value, 0.0), 1.0);
    }

    @Override
    public void openGui(H handler, GuiScreen gui) {
    }

    @Override
    public void initGui(H handler, GuiScreen gui) {
    }

    @Override
    public void drawGuiPre(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void drawBackground(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void drawGuiPost(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
        if (this.dragged) {
            this.value = (double)(mouseX - (this.xPos + this.borderX + this.sliderWidth / 2)) / (double)(this.width - this.sliderWidth);
            this.checkSliderValue();
        }
        gui.field_146297_k.func_110434_K().func_110577_a(buttonTextures);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IntegralSliderGuiElement.drawTexturedRect(new Rectangle(this.xPos + this.borderX + (int)(this.value * (double)(this.width - this.sliderWidth)), this.yPos + this.borderY, this.sliderWidth / 2, this.height), new Rectangle(0, 66, 4, 20), 256, 256);
        IntegralSliderGuiElement.drawTexturedRect(new Rectangle(this.xPos + this.borderX + (int)(this.value * (double)(this.width - this.sliderWidth)) + this.sliderWidth / 2, this.yPos + this.borderY, this.sliderWidth / 2, this.height), new Rectangle(196, 66, 4, 20), 256, 256);
        if (this.displayValue) {
            int w = gui.field_146297_k.field_71466_p.func_78256_a(String.valueOf(this.getValue()));
            Rectangle r = IntegralSliderGuiElement.smartPos(this.toRectangle(), new Rectangle(this.xPos + this.borderX + (int)(this.value * (double)(this.width - this.sliderWidth)), this.yPos + this.borderY, this.sliderWidth, this.height), new Rectangle(this.xPos + this.borderX + (this.width - w) / 2, this.yPos + this.borderY + (this.height - 8) / 2, w, 8), false, false);
            IntegralSliderGuiElement.drawStringFull(gui.field_146297_k.field_71466_p, String.valueOf(this.getValue()), r.getX(), this.yPos + this.borderY + (this.height - 8) / 2, this.textColor);
        }
    }

    @Override
    public void drawGuiPostPost(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public boolean handleKeyboardEvent(H handler, GuiScreen gui, boolean down, int key, char c) {
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (key == 0) {
            if (down) {
                if (this.inside(mouseX, mouseY)) {
                    if ((double)(this.xPos + this.borderX) + this.value * (double)this.width - (double)(this.sliderWidth / 2) <= (double)mouseX && (double)mouseX <= (double)(this.xPos + this.borderX) + this.value * (double)this.width + (double)(this.sliderWidth / 2)) {
                        this.dragged = true;
                    } else {
                        this.value = (double)(mouseX - (this.xPos + this.borderX + this.sliderWidth / 2)) / (double)(this.width - this.sliderWidth);
                        this.checkSliderValue();
                    }
                }
            } else if (this.dragged) {
                this.dragged = false;
                this.value = (double)(mouseX - (this.xPos + this.borderX + this.sliderWidth / 2)) / (double)(this.width - this.sliderWidth);
                this.checkSliderValue();
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, int dWheel) {
        return false;
    }
}

