/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.color;

import code.elix_x.excomms.color.HSBA;
import java.util.Objects;

public final class RGBA {
    private final float r;
    private final float g;
    private final float b;
    private final float a;
    public static final float DEFAULTEQUALSDELTA = 1.0E-5f;

    public RGBA(float r, float g, float b, float a) {
        this.r = Math.min(Math.max(r, 0.0f), 1.0f);
        this.g = Math.min(Math.max(g, 0.0f), 1.0f);
        this.b = Math.min(Math.max(b, 0.0f), 1.0f);
        this.a = Math.min(Math.max(a, 0.0f), 1.0f);
    }

    public RGBA(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public RGBA() {
        this(0.0f, 0.0f, 0.0f);
    }

    public RGBA(int r, int g, int b, int a, int mv) {
        this((float)r / (float)mv, (float)g / (float)mv, (float)b / (float)mv, (float)a / (float)mv);
    }

    public RGBA(int r, int g, int b, int a) {
        this(r, g, b, a, 255);
    }

    public RGBA(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public float getRF() {
        return this.r;
    }

    public float getGF() {
        return this.g;
    }

    public float getBF() {
        return this.b;
    }

    public float getAF() {
        return this.a;
    }

    public RGBA setRF(float r) {
        return new RGBA(r, this.g, this.b, this.a);
    }

    public RGBA setGF(float g) {
        return new RGBA(this.r, g, this.b, this.a);
    }

    public RGBA setBF(float b) {
        return new RGBA(this.r, this.g, b, this.a);
    }

    public RGBA setAF(float a) {
        return new RGBA(this.r, this.g, this.b, a);
    }

    public int getRI(int mv) {
        return (int)(this.r * (float)mv);
    }

    public int getGI(int mv) {
        return (int)(this.g * (float)mv);
    }

    public int getBI(int mv) {
        return (int)(this.b * (float)mv);
    }

    public int getAI(int mv) {
        return (int)(this.a * (float)mv);
    }

    public int getRI() {
        return this.getRI(255);
    }

    public int getGI() {
        return this.getGI(255);
    }

    public int getBI() {
        return this.getBI(255);
    }

    public int getAI() {
        return this.getAI(255);
    }

    public RGBA setRI(int r, int mv) {
        return this.setRF((float)r / (float)mv);
    }

    public RGBA setGI(int g, int mv) {
        return this.setGF((float)g / (float)mv);
    }

    public RGBA setBI(int b, int mv) {
        return this.setBF((float)b / (float)mv);
    }

    public RGBA setAI(int a, int mv) {
        return this.setAF((float)a / (float)mv);
    }

    public RGBA setRI(int r) {
        return this.setRI(r, 255);
    }

    public RGBA setGI(int g) {
        return this.setGI(g, 255);
    }

    public RGBA setBI(int b) {
        return this.setBI(b, 255);
    }

    public RGBA setAI(int a) {
        return this.setAI(a, 255);
    }

    public int argb() {
        return this.getAI() << 24 | this.getRI() << 16 | this.getGI() << 8 | this.getBI();
    }

    public static RGBA fromARGB(int argb) {
        return new RGBA(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public int rgba() {
        return this.getRI() << 24 | this.getGI() << 16 | this.getBI() << 8 | this.getAI();
    }

    public static RGBA fromRGBA(int argb) {
        return new RGBA(argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public HSBA toHSBA() {
        float min;
        float max = Math.max(Math.max(this.r, this.g), this.b);
        float d = max - (min = Math.min(Math.min(this.r, this.g), this.b));
        float h = d == 0.0f ? 0.0f : (this.r == max ? (this.g - this.b) / d : (this.g == max ? 2.0f + (this.b - this.r) / d : 4.0f + (this.r - this.g) / d));
        return new HSBA(h / 6.0f, max != 0.0f ? d / max : 0.0f, max, this.a);
    }

    private static boolean deltaEquals(float a, float b, float delta) {
        return Math.abs(a - b) < 1.0E-5f;
    }

    public boolean equals(RGBA rgba, float delta) {
        return RGBA.deltaEquals(rgba.r, this.r, delta) && RGBA.deltaEquals(rgba.g, this.g, delta) && RGBA.deltaEquals(rgba.b, this.b, delta) && RGBA.deltaEquals(rgba.a, this.a, delta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.equals((RGBA)o, 1.0E-5f);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public String toString() {
        return "RGBA{ " + this.r + ", " + this.g + ", " + this.b + ", " + this.a + "}";
    }
}

