/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.color;

import code.elix_x.excomms.color.RGBA;
import java.util.Objects;

public final class HSBA {
    private final float h;
    private final float s;
    private final float b;
    private final float a;
    public static final float DEFAULTEQUALSDELTA = 1.0E-5f;

    public HSBA(float h, float s, float b, float a) {
        float mh = h % 1.0f;
        this.h = mh > 0.0f ? mh : 1.0f + mh;
        this.s = Math.min(Math.max(s, 0.0f), 1.0f);
        this.b = Math.min(Math.max(b, 0.0f), 1.0f);
        this.a = Math.min(Math.max(a, 0.0f), 1.0f);
    }

    public HSBA(float h, float s, float b) {
        this(h, s, b, 1.0f);
    }

    public HSBA() {
        this(0.0f, 0.0f, 0.0f);
    }

    public float getH() {
        return this.h;
    }

    public double getHRad() {
        return (double)(this.h * 2.0f) * Math.PI;
    }

    public double getHDeg() {
        return this.h * 360.0f;
    }

    public float getS() {
        return this.s;
    }

    public float getB() {
        return this.b;
    }

    public float getA() {
        return this.a;
    }

    public HSBA setH(float h) {
        return new HSBA(h, this.s, this.b, this.a);
    }

    public HSBA setHRad(double rad) {
        return this.setH((float)(rad / (Math.PI * 2)));
    }

    public HSBA setHDeg(double deg) {
        return this.setH((float)(deg / 360.0));
    }

    public HSBA setS(float s) {
        return new HSBA(this.h, s, this.b, this.a);
    }

    public HSBA setB(float b) {
        return new HSBA(this.h, this.s, b, this.a);
    }

    public HSBA setA(float a) {
        return new HSBA(this.h, this.s, this.b, a);
    }

    public RGBA toRGBA() {
        float r;
        float g;
        float b;
        if (this.s == 0.0f) {
            g = b = this.b;
            r = b;
        } else {
            float h6 = this.h * 6.0f;
            if (h6 == 6.0f) {
                h6 = 0.0f;
            }
            int hi = (int)Math.floor(h6);
            float c1 = this.b * (1.0f - this.s);
            float c2 = this.b * (1.0f - this.s * (h6 - (float)hi));
            float c3 = this.b * (1.0f - this.s * (1.0f - (h6 - (float)hi)));
            if (hi == 0) {
                r = this.b;
                g = c3;
                b = c1;
            } else if (hi == 1) {
                r = c2;
                g = this.b;
                b = c1;
            } else if (hi == 2) {
                r = c1;
                g = this.b;
                b = c3;
            } else if (hi == 3) {
                r = c1;
                g = c2;
                b = this.b;
            } else if (hi == 4) {
                r = c3;
                g = c1;
                b = this.b;
            } else {
                r = this.b;
                g = c1;
                b = c2;
            }
        }
        return new RGBA(r, g, b, this.a);
    }

    private static boolean deltaEquals(float a, float b, float delta) {
        return Math.abs(a - b) < 1.0E-5f;
    }

    public boolean equals(HSBA hsba, float delta) {
        return HSBA.deltaEquals(hsba.h, this.h, delta) && HSBA.deltaEquals(hsba.s, this.s, delta) && HSBA.deltaEquals(hsba.b, this.b, delta) && HSBA.deltaEquals(hsba.a, this.a, delta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.equals((HSBA)o, 1.0E-5f);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.h), Float.valueOf(this.s), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public String toString() {
        return "HSBA{" + this.h + ", " + this.s + ", " + this.b + ", " + this.a + '}';
    }
}

