/*
 * Decompiled with CFR 0.152.
 */
package io.sommers.packmode;

import com.google.common.collect.Lists;
import io.sommers.packmode.PMConfig;
import io.sommers.packmode.PackModeCommand;
import io.sommers.packmode.api.PackModeAPI;
import io.sommers.packmode.api.PackModeChangedEvent;
import io.sommers.packmode.compat.CompatHandler;
import io.sommers.packmode.proxy.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="packmode", name="PackMode", version="1.2.0", dependencies="after:crafttweaker;after:gamestages@[2.0.0,)", acceptedMinecraftVersions="[1.12.2, 1.13)")
public class PackMode {
    public static final String MOD_ID = "packmode";
    public static final String MOD_NAME = "PackMode";
    public static final String VERSION = "1.2.0";
    public static final String DEPENDS = "after:crafttweaker;after:gamestages@[2.0.0,)";
    public static final String MC_VERSIONS = "[1.12.2, 1.13)";
    public static Logger logger;
    @SidedProxy(clientSide="io.sommers.packmode.proxy.ClientProxy", serverSide="io.sommers.packmode.proxy.ServerProxy")
    public static CommonProxy<EntityPlayer> proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PMConfig.init(event.getSuggestedConfigurationFile());
        logger = event.getModLog();
        PackModeAPI.createInstance(PMConfig.getPackMode(), Lists.newArrayList((Object[])PMConfig.getAcceptedModes()));
        CompatHandler.tryActivate();
        CompatHandler.preInit();
        if (PMConfig.getConfiguration().hasChanged()) {
            PMConfig.getConfiguration().save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new PackModeCommand());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPackModeChanged(PackModeChangedEvent event) {
        PMConfig.setPackMode(event.getNextRestartPackMode());
    }
}

