/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.BlockAirCompressor;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityAirCompressor
extends TileEntityPneumaticBase
implements IRedstoneControlled {
    private static final int INVENTORY_SIZE = 1;
    private AirCompressorHandler inventory = new AirCompressorHandler();
    private static final int FUEL_SLOT = 0;
    @GuiSynced
    public int burnTime;
    @GuiSynced
    private int maxBurnTime;
    @GuiSynced
    public int redstoneMode = 0;
    @DescSynced
    private boolean isActive;
    @GuiSynced
    public int curFuelUsage;

    public TileEntityAirCompressor() {
        this(5.0f, 7.0f, 5000);
    }

    public TileEntityAirCompressor(float dangerPressure, float criticalPressure, int volume) {
        super(dangerPressure, criticalPressure, volume, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    @Override
    public void func_73660_a() {
        List<Pair<EnumFacing, IAirHandler>> teList;
        if (!this.func_145831_w().field_72995_K) {
            if (this.redstoneAllows() && this.burnTime < this.curFuelUsage && TileEntityFurnace.func_145954_b((ItemStack)this.inventory.getStackInSlot(0))) {
                ItemStack fuelStack = this.inventory.getStackInSlot(0);
                this.burnTime += TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                this.maxBurnTime = this.burnTime;
                fuelStack.func_190918_g(1);
            }
            this.curFuelUsage = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() / 10.0f);
            if (this.burnTime >= this.curFuelUsage) {
                this.burnTime -= this.curFuelUsage;
                if (!this.func_145831_w().field_72995_K) {
                    this.addAir((int)((double)((float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades() * (float)this.getEfficiency()) / 100.0));
                    this.onFuelBurn(this.curFuelUsage);
                }
            }
            boolean wasActive = this.isActive;
            boolean bl = this.isActive = this.burnTime > this.curFuelUsage;
            if (wasActive != this.isActive) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockAirCompressor.ON, (Comparable)Boolean.valueOf(this.isActive)));
            }
        } else if (this.isActive) {
            this.spawnBurningParticle();
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && (teList = this.getAirHandler(null).getConnectedPneumatics()).size() == 0) {
            this.getAirHandler(null).airLeak(this.getRotation());
        }
    }

    protected void onFuelBurn(int burnedFuel) {
    }

    public int getEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    private void spawnBurningParticle() {
        Random rand = new Random();
        if (rand.nextInt(3) != 0) {
            return;
        }
        float f = (float)this.func_174877_v().func_177958_n() + 0.5f;
        float f1 = (float)this.func_174877_v().func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)this.func_174877_v().func_177952_p() + 0.5f;
        float f3 = 0.5f;
        float f4 = rand.nextFloat() * 0.4f - 0.2f;
        switch (this.getRotation()) {
            case EAST: {
                this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case WEST: {
                this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
                this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return this.getRotation() == side;
    }

    public int getBurnTimeRemainingScaled(int parts) {
        if (this.maxBurnTime == 0 || this.burnTime < this.curFuelUsage) {
            return 0;
        }
        return parts * this.burnTime / this.maxBurnTime;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public String getName() {
        return Blockss.AIR_COMPRESSOR.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.burnTime = nbtTagCompound.func_74762_e("burnTime");
        this.maxBurnTime = nbtTagCompound.func_74762_e("maxBurn");
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
        this.inventory = new AirCompressorHandler();
        this.inventory.deserializeNBT(nbtTagCompound.func_74775_l("Items"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("burnTime", this.burnTime);
        nbtTagCompound.func_74768_a("maxBurn", this.maxBurnTime);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        nbtTagCompound.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return nbtTagCompound;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    private class AirCompressorHandler
    extends FilteredItemStackHandler {
        AirCompressorHandler() {
            super(TileEntityAirCompressor.this, 1);
        }

        @Override
        public boolean test(Integer slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.func_190926_b() || TileEntityFurnace.func_145954_b((ItemStack)itemStack) && FluidUtil.getFluidContained((ItemStack)itemStack) == null);
        }
    }
}

