/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mcmultipart;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.addon.IMCMPAddon;
import mcmultipart.api.addon.MCMPAddon;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartRegistry;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileMultipartContainer;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.mcmultipart.IMultipartTE;
import me.desht.pneumaticcraft.common.thirdparty.mcmultipart.PartPressureTube;
import me.desht.pneumaticcraft.common.thirdparty.mcmultipart.PartPressureTubeTile;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MCMPAddon
public class PneumaticMultiPart
implements IMCMPAddon,
IThirdParty {
    private static boolean enabled = false;

    public void registerParts(IMultipartRegistry registry) {
        if (!enabled) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        registry.registerPartWrapper(Blockss.PRESSURE_TUBE, (IMultipart)new PartPressureTube((BlockPressureTube)Blockss.PRESSURE_TUBE));
        registry.registerStackWrapper(Item.func_150898_a((Block)Blockss.PRESSURE_TUBE), s -> true, Blockss.PRESSURE_TUBE);
        registry.registerPartWrapper(Blockss.ADVANCED_PRESSURE_TUBE, (IMultipart)new PartPressureTube((BlockPressureTube)Blockss.ADVANCED_PRESSURE_TUBE));
        registry.registerStackWrapper(Item.func_150898_a((Block)Blockss.ADVANCED_PRESSURE_TUBE), s -> true, Blockss.ADVANCED_PRESSURE_TUBE);
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<TileEntity> e) {
        if (!enabled) {
            return;
        }
        TileEntity tile = (TileEntity)e.getObject();
        if (tile instanceof IMultipartTE) {
            this.register(e, ((IMultipartTE)tile).getMultipartId());
        }
    }

    private void register(final AttachCapabilitiesEvent<TileEntity> e, String multipartId) {
        if (e.getCapabilities().containsKey(PneumaticCraftUtils.RL(multipartId))) {
            return;
        }
        e.addCapability(PneumaticCraftUtils.RL(multipartId), new ICapabilityProvider(){
            private PartPressureTubeTile tile;

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == MCMPCapabilities.MULTIPART_TILE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == MCMPCapabilities.MULTIPART_TILE) {
                    if (this.tile == null) {
                        this.tile = new PartPressureTubeTile((TileEntity)e.getObject());
                    }
                    return (T)MCMPCapabilities.MULTIPART_TILE.cast((Object)this.tile);
                }
                return null;
            }
        });
    }

    @Nullable
    public static TileEntity unwrapTile(IBlockAccess world, BlockPos pos) {
        Optional multipartTile;
        TileEntity tile = PneumaticCraftUtils.getTileEntitySafely(world, pos);
        if (tile instanceof TileMultipartContainer && (multipartTile = ((TileMultipartContainer)tile).getPartTile((IPartSlot)EnumCenterSlot.CENTER)).isPresent()) {
            return ((IMultipartTile)multipartTile.get()).getTileEntity();
        }
        return tile;
    }

    public static Block unwrapBlock(IBlockAccess world, BlockPos pos) {
        Optional info;
        Optional multipartContainer;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockMultipartContainer && (multipartContainer = BlockMultipartContainer.getTile((IBlockAccess)world, (BlockPos)pos)).isPresent() && (info = ((TileMultipartContainer)multipartContainer.get()).get((IPartSlot)EnumCenterSlot.CENTER)).isPresent()) {
            return ((IPartInfo)info.get()).getPart().getBlock();
        }
        return state.func_177230_c();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        enabled = true;
    }
}

