/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemGunAmmo
extends ItemPneumatic {
    public ItemGunAmmo(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(this.getCartridgeSize());
    }

    protected abstract int getCartridgeSize();

    public float getRangeMultiplier(ItemStack ammoStack) {
        return 1.0f;
    }

    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        return 1.0f;
    }

    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract int getAmmoColor(ItemStack var1);

    public int getAmmoCost(ItemStack ammoStack) {
        return 1;
    }

    protected DamageSource getDamageSource(Minigun minigun) {
        return DamageSource.func_76365_a((EntityPlayer)minigun.getPlayer());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> infoList, ITooltipFlag extraInfo) {
        infoList.add(I18n.func_135052_a((String)"gui.tooltip.gunAmmo.ammoRemaining", (Object[])new Object[]{stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()}));
        super.func_77624_a(stack, world, infoList, extraInfo);
    }

    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        int times = 1;
        int nSpeed = minigun.getUpgrades(IItemRegistry.EnumUpgrade.SPEED);
        for (int i = 0; i < nSpeed; ++i) {
            if (minigun.getWorld().field_73012_v.nextInt(100) >= 20) continue;
            ++times;
        }
        float dmgMult = this.getDamageMultiplier(target, ammo);
        if (dmgMult > 0.0f) {
            if (target instanceof MultiPartEntityPart) {
                ((MultiPartEntityPart)target).field_70259_a.func_70965_a((MultiPartEntityPart)target, this.getDamageSource(minigun), ConfigHandler.minigun.baseDamage * dmgMult * (float)times);
            } else if (target instanceof EntityLivingBase || target instanceof EntityEnderCrystal) {
                target.func_70097_a(this.getDamageSource(minigun), ConfigHandler.minigun.baseDamage * dmgMult * (float)times);
            } else if (target instanceof EntityShulkerBullet || target instanceof EntityFireball) {
                target.func_70106_y();
            }
        }
        return times;
    }

    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        double x = pos.func_177958_n() + face.func_82601_c();
        double y = pos.func_177956_o() + face.func_96559_d();
        double z = pos.func_177952_p() + face.func_82599_e();
        World w = minigun.getPlayer().field_70170_p;
        IBlockState state = w.func_180495_p(pos);
        ((WorldServer)w).func_175739_a(EnumParticleTypes.BLOCK_DUST, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, 10, (double)face.func_82601_c() * 0.2, (double)face.func_96559_d() * 0.2, (double)face.func_82599_e() * 0.2, 0.05, new int[]{Block.func_176210_f((IBlockState)state)});
        return 1;
    }
}

