/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourLiquid;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class HeatBehaviourTransition
extends HeatBehaviourLiquid {
    private double extractedHeat;
    private double maxExchangedHeat;
    private double blockTemp = -1.0;
    private IHeatExchangerLogic logic;

    @Override
    public void initialize(IHeatExchangerLogic connectedHeatLogic, World world, BlockPos pos, EnumFacing direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.extractedHeat = connectedHeatLogic.getHeatExtracted(direction);
    }

    @Override
    public boolean isApplicable() {
        this.logic = HeatExchangerManager.getInstance().getLogic(this.getWorld(), this.getPos(), null);
        return this.logic != null;
    }

    protected abstract int getMaxExchangedHeat();

    protected abstract boolean transitionOnTooMuchExtraction();

    @Override
    public double getHeatExtracted() {
        return this.extractedHeat;
    }

    @Override
    public void update() {
        if (this.blockTemp == -1.0) {
            this.blockTemp = this.logic.getTemperature();
            this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (this.logic.getThermalResistance() + this.getHeatExchanger().getThermalResistance());
        }
        this.extractedHeat += this.blockTemp - this.getHeatExchanger().getTemperature();
        if (this.transitionOnTooMuchExtraction() ? this.extractedHeat > this.maxExchangedHeat : this.extractedHeat < -this.maxExchangedHeat) {
            this.extractedHeat %= this.maxExchangedHeat;
            this.transformBlock();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("extractedHeat", this.extractedHeat);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.extractedHeat = tag.func_74769_h("extractedHeat");
    }

    protected abstract void transformBlock();

    void onTransition(BlockPos pos) {
        NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187541_bC, SoundCategory.AMBIENT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f, true), this.getWorld());
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, 8, 1.0, 0.0, 1.0), this.getWorld());
    }
}

