/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class HeatUtil {
    private static final int MIN_HEAT_LEVEL_TEMPERATURE = 73;
    private static final int MAX_HEAT_LEVEL_TEMPERATURE = 473;
    private static final float[][] HEAT_TINT_MAP = new float[20][];

    public static int getHeatLevelForTemperature(double temperature) {
        if (temperature < 73.0) {
            return 0;
        }
        if (temperature > 473.0) {
            return 19;
        }
        return (int)((temperature - 73.0) * 20.0 / 400.0);
    }

    public static float[] getColorForHeatLevel(int heatLevel) {
        return HEAT_TINT_MAP[MathHelper.func_76125_a((int)heatLevel, (int)0, (int)19)];
    }

    public static int getComparatorOutput(int temperature) {
        if ((temperature -= 200) < 73) {
            return 0;
        }
        if (temperature > 473) {
            return 15;
        }
        return (temperature - 73) * 16 / 400;
    }

    public static String formatHeatString(int tempK) {
        return PneumaticCraftUtils.xlate("waila.temperature") + " " + TextFormatting.WHITE + (tempK - 273) + "\u00b0C";
    }

    public static String formatHeatString(EnumFacing face, int tempK) {
        return PneumaticCraftUtils.xlate("waila.temperature." + face.toString().toLowerCase()) + " " + TextFormatting.WHITE + (tempK - 273) + "\u00b0C";
    }

    static {
        for (int i = 0; i < 20; ++i) {
            if (i > 11) {
                float greenAndBlue = 1.0f - (float)(i - 11) / 10.0f;
                HeatUtil.HEAT_TINT_MAP[i] = new float[]{1.0f, greenAndBlue, greenAndBlue * 0.9f};
                continue;
            }
            if (i < 11) {
                float redAndGreen = (float)i / 10.0f;
                HeatUtil.HEAT_TINT_MAP[i] = new float[]{redAndGreen * 0.9f, redAndGreen, 1.0f};
                continue;
            }
            HeatUtil.HEAT_TINT_MAP[i] = new float[]{1.0f, 1.0f, 1.0f};
        }
    }
}

