/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.tubes.IPneumaticPosProvider;
import me.desht.pneumaticcraft.common.block.tubes.ISidedPart;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegistrator;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketOpenTubeModuleGui;
import me.desht.pneumaticcraft.common.thirdparty.ModInteractionUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TubeModule
implements ISidedPart {
    public static final float MAX_VALUE = 30.0f;
    protected IPneumaticPosProvider pressureTube;
    protected EnumFacing dir = EnumFacing.UP;
    public final AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[6];
    protected boolean upgraded;
    public float lowerBound = 7.5f;
    public float higherBound = 0.0f;
    private boolean fake;
    public boolean advancedConfig;
    public boolean shouldDrop;
    @SideOnly(value=Side.CLIENT)
    private ModelModuleBase model;

    public TubeModule() {
        double width = this.getWidth() / 2.0;
        double height = this.getHeight();
        this.boundingBoxes[0] = new AxisAlignedBB(0.5 - width, 0.375 - height, 0.5 - width, 0.5 + width, 0.375, 0.5 + width);
        this.boundingBoxes[1] = new AxisAlignedBB(0.5 - width, 0.625, 0.5 - width, 0.5 + width, 0.625 + height, 0.5 + width);
        this.boundingBoxes[2] = new AxisAlignedBB(0.5 - width, 0.5 - width, 0.375 - height, 0.5 + width, 0.5 + width, 0.375);
        this.boundingBoxes[3] = new AxisAlignedBB(0.5 - width, 0.5 - width, 0.625, 0.5 + width, 0.5 + width, 0.625 + height);
        this.boundingBoxes[4] = new AxisAlignedBB(0.375 - height, 0.5 - width, 0.5 - width, 0.375, 0.5 + width, 0.5 + width);
        this.boundingBoxes[5] = new AxisAlignedBB(0.625, 0.5 - width, 0.5 - width, 0.625 + height, 0.5 + width, 0.5 + width);
    }

    public void markFake() {
        this.fake = true;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setTube(IPneumaticPosProvider pressureTube) {
        this.pressureTube = pressureTube;
    }

    public IPneumaticPosProvider getTube() {
        return this.pressureTube;
    }

    public double getWidth() {
        return 0.25;
    }

    protected double getHeight() {
        return 0.375;
    }

    public float getThreshold(int redstone) {
        double slope = (this.higherBound - this.lowerBound) / 15.0f;
        double threshold = (double)this.lowerBound + slope * (double)redstone;
        return (float)threshold;
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.shouldDrop) {
            drops.add(new ItemStack(ModuleRegistrator.getModuleItem(this.getType())));
            if (this.upgraded) {
                drops.add(new ItemStack(Itemss.ADVANCED_PCB));
            }
        }
        return drops;
    }

    @Override
    public void setDirection(EnumFacing dir) {
        this.dir = dir;
    }

    public EnumFacing getDirection() {
        return this.dir;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.dir = EnumFacing.func_82600_a((int)nbt.func_74762_e("dir"));
        this.upgraded = nbt.func_74767_n("upgraded");
        this.lowerBound = nbt.func_74760_g("lowerBound");
        this.higherBound = nbt.func_74760_g("higherBound");
        this.advancedConfig = !nbt.func_74764_b("advancedConfig") || nbt.func_74767_n("advancedConfig");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dir", this.dir.ordinal());
        nbt.func_74757_a("upgraded", this.upgraded);
        nbt.func_74776_a("lowerBound", this.lowerBound);
        nbt.func_74776_a("higherBound", this.higherBound);
        nbt.func_74757_a("advancedConfig", this.advancedConfig);
    }

    public void update() {
    }

    public void onNeighborTileUpdate() {
    }

    public void onNeighborBlockUpdate() {
    }

    public abstract String getType();

    public int getRedstoneLevel() {
        return 0;
    }

    protected void updateNeighbors() {
        this.pressureTube.world().func_175685_c(this.pressureTube.pos(), this.pressureTube.world().func_180495_p(this.pressureTube.pos()).func_177230_c(), true);
    }

    public boolean isInline() {
        return false;
    }

    public void sendDescriptionPacket() {
        ModInteractionUtils.getInstance().sendDescriptionPacket(this.pressureTube);
    }

    public void addInfo(List<String> curInfo) {
    }

    public void addItemDescription(List<String> curInfo) {
    }

    public boolean canUpgrade() {
        return true;
    }

    public void upgrade() {
        this.upgraded = true;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean onActivated(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.upgraded && this.getGuiId() != null) {
            NetworkHandler.sendTo(new PacketOpenTubeModuleGui(this.getGuiId().ordinal(), this.pressureTube.pos()), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }

    protected abstract GuiHandler.EnumGuiId getGuiId();

    @SideOnly(value=Side.CLIENT)
    public abstract Class<? extends ModelModuleBase> getModelClass();

    @SideOnly(value=Side.CLIENT)
    public final ModelModuleBase getModel() {
        if (this.model == null) {
            try {
                Constructor<? extends ModelModuleBase> ctor = this.getModelClass().getDeclaredConstructor(this.getClass());
                this.model = ctor.newInstance(this);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                this.model = new ModelModuleBase.MissingModel();
            }
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public void doExtraRendering() {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return null;
    }
}

