/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.thermalexpansion.recipehandler;

import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.capability.recipehandler.TransformedRecipeHandlerAdapter;
import org.cyclops.commoncapabilities.modcompat.thermalexpansion.ThermalExpansionHelpers;

public class TileRefineryRecipeHandler
extends TransformedRecipeHandlerAdapter<RefineryManager.RefineryRecipe> {
    private final TileRefinery tile;

    public TileRefineryRecipeHandler(TileRefinery tile) {
        super(Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK, IngredientComponent.ITEMSTACK}));
        this.tile = tile;
    }

    protected boolean isAugmentPotion() {
        try {
            return (Boolean)ThermalExpansionHelpers.FIELD_TILEREFINERY_AUGMENTPOTION.get(this.tile);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    @Override
    protected String getRecipeCacheKey() {
        return "thermalexpansion:refinery:" + this.isAugmentPotion();
    }

    @Override
    protected IRecipeDefinition transformRecipe(RefineryManager.RefineryRecipe recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, recipe.getInput(), 7)}))}));
        if (recipe.getChance() == 1) {
            outputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutputItem()}));
        }
        if (recipe.getOutputFluid() != null) {
            outputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getOutputFluid()}));
        }
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected RefineryManager.RefineryRecipe findRecipe(IMixedIngredients input) {
        if (this.isAugmentPotion()) {
            return RefineryManager.getRecipePotion((FluidStack)((FluidStack)Iterables.getFirst(input.getInstances(IngredientComponent.FLUIDSTACK), null)));
        }
        return RefineryManager.getRecipe((FluidStack)((FluidStack)Iterables.getFirst(input.getInstances(IngredientComponent.FLUIDSTACK), null)));
    }

    @Override
    protected Collection<RefineryManager.RefineryRecipe> getRecipesRaw() {
        return Lists.newArrayList((Object[])(this.isAugmentPotion() ? RefineryManager.getRecipeListPotion() : RefineryManager.getRecipeList()));
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.FLUIDSTACK && size == 1;
    }
}

