/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.tconstruct.capability.recipehandler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class TileSmelteryRecipeHandler
implements IRecipeHandler {
    private static final TileSmelteryRecipeHandler INSTANCE = new TileSmelteryRecipeHandler();
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK});
    private static List<IRecipeDefinition> RECIPES = null;

    public static TileSmelteryRecipeHandler getInstance() {
        return INSTANCE;
    }

    private TileSmelteryRecipeHandler() {
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.ITEMSTACK && size == 1 || component == IngredientComponent.FLUIDSTACK && size > 1;
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        if (RECIPES == null) {
            RECIPES = TinkerRegistry.getAllMeltingRecipies().stream().map(recipe -> {
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                IdentityHashMap outputs = Maps.newIdentityHashMap();
                if (recipe.input.getInputs().isEmpty()) {
                    return null;
                }
                inputs.put(IngredientComponent.ITEMSTACK, recipe.input.getInputs().stream().map(input -> new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)input, 15)}))).collect(Collectors.toList()));
                outputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getResult()}));
                return new RecipeDefinition(inputs, new MixedIngredients(outputs));
            }).filter(Objects::nonNull).collect(Collectors.toList());
            RECIPES.addAll(TinkerRegistry.getAlloys().stream().map(recipe -> {
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                IdentityHashMap outputs = Maps.newIdentityHashMap();
                if (recipe.getFluids().size() == 0) {
                    return null;
                }
                inputs.put(IngredientComponent.FLUIDSTACK, recipe.getFluids().stream().map(input -> new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, (FluidStack)input, 7)}))).collect(Collectors.toList()));
                outputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getResult()}));
                return new RecipeDefinition(inputs, new MixedIngredients(outputs));
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return RECIPES;
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        if (input.getComponents().contains(IngredientComponent.ITEMSTACK)) {
            ItemStack itemStack = (ItemStack)Iterables.getFirst(input.getInstances(IngredientComponent.ITEMSTACK), (Object)ItemStack.field_190927_a);
            MeltingRecipe recipe = TinkerRegistry.getMelting((ItemStack)itemStack);
            if (recipe == null) {
                return null;
            }
            IdentityHashMap ingredientsMap = Maps.newIdentityHashMap();
            ingredientsMap.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getResult()}));
            return new MixedIngredients(ingredientsMap);
        }
        if (input.getComponents().contains(IngredientComponent.FLUIDSTACK)) {
            List<FluidStack> fluidStacks = input.getInstances(IngredientComponent.FLUIDSTACK);
            for (AlloyRecipe recipe : TinkerRegistry.getAlloys()) {
                int matches = recipe.matches(fluidStacks);
                if (matches <= 0) continue;
                FluidStack result = recipe.getResult().copy();
                result.amount *= matches;
                IdentityHashMap ingredientsMap = Maps.newIdentityHashMap();
                ingredientsMap.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{result}));
                return new MixedIngredients(ingredientsMap);
            }
        }
        return null;
    }
}

