/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placementhandlers.IPlacementHandler;
import com.ldtteam.structurize.placementhandlers.PlacementHandlers;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class InstantStructurePlacer
extends com.ldtteam.structurize.util.InstantStructurePlacer {
    public InstantStructurePlacer(World worldObj, String name) {
        super(new Structure(worldObj, name, new PlacementSettings()));
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror, boolean complete) {
        try {
            InstantStructurePlacer structureWrapper = new InstantStructurePlacer(worldObj, name);
            structureWrapper.structure.setPosition(pos);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.placeStructure(pos.func_177973_b((Vec3i)structureWrapper.structure.getOffset()), complete);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotate(BlockPosUtil.getRotationFromRotations(times), world, rotatePos, mirror);
    }

    private void placeStructure(@NotNull BlockPos pos, boolean complete) {
        BlockPos localPos;
        this.structure.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (localBlock == ModBlocks.blockSubstitution && !complete || localBlock instanceof AbstractBlockHut) continue;
                    if (localState.func_185904_a().func_76220_a()) {
                        this.handleBlockPlacement(worldPos, localState, complete, this.structure.getBlockInfo(localPos).getTileEntityData(), this.structure.getWorld());
                        continue;
                    }
                    delayedBlocks.add(localPos);
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            BlockPos newWorldPos = pos.func_177971_a((Vec3i)coords);
            this.handleBlockPlacement(newWorldPos, localState, complete, this.structure.getBlockInfo(coords).getTileEntityData(), this.structure.getWorld());
        }
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    localPos = new BlockPos(i, j, k);
                    NBTTagCompound info = this.structure.getEntityData(localPos);
                    if (info == null) continue;
                    try {
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)info, (World)this.structure.getWorld());
                        entity.func_184221_a(UUID.randomUUID());
                        this.structure.getWorld().func_72838_d(entity);
                        continue;
                    }
                    catch (RuntimeException e) {
                        Log.getLogger().info("Couldn't restore entity", (Throwable)e);
                    }
                }
            }
        }
    }

    private void handleBlockPlacement(BlockPos pos, IBlockState localState, boolean complete, NBTTagCompound tileEntityData, World world) {
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            if (!handlers.canHandle(world, pos, localState)) continue;
            Object result = handlers.handle(world, pos, localState, tileEntityData, complete, this.structure.getLocalPosition());
            if (result instanceof IBlockState) {
                AbstractBuilding building;
                IBlockState blockState = (IBlockState)result;
                Colony colony = ColonyManager.getColonyByPosFromWorld(world, pos);
                if (colony != null && (building = colony.getBuildingManager().getBuilding(this.structure.getPosition())) != null) {
                    building.registerBlockPosition(blockState, pos, world);
                }
                return;
            }
            return;
        }
    }

    public static boolean tryToLoadAndPlaceSupplyCampWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            InstantStructurePlacer structureWrapper = new InstantStructurePlacer(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            if (structureWrapper.checkForFreeSpace(pos)) {
                structureWrapper.placeStructure(pos, false);
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return false;
        }
    }
}

