/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityChiefBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityArcherPirate;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityCaptainPirate;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityPirate;
import com.minecolonies.coremod.inventory.GuiHandler;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.proxy.IProxy;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.tileentities.TileEntityBarrel;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.tileentities.TileEntityInfoPoster;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import com.minecolonies.coremod.util.TownHallRecipe;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CommonProxy
implements IProxy {
    private static final int PRIMARY_COLOR_BARBARIAN = 5;
    private static final int SECONDARY_COLOR_BARBARIAN = 700;
    private static final int PRIMARY_COLOR_PIRATE = 7;
    private static final int SECONDARY_COLOR_PIRATE = 600;
    private static final Map<String, NBTTagCompound> playerPropertiesData = new HashMap<String, NBTTagCompound>();
    private int nextEntityId = 0;

    public static void storeEntityData(String name, NBTTagCompound compound) {
        playerPropertiesData.put(name, compound);
    }

    public static NBTTagCompound getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
        ModBlocks.init((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerRecipes(@NotNull RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new TownHallRecipe());
    }

    @SubscribeEvent
    public static void registerItems(@NotNull RegistryEvent.Register<Item> event) {
        ModItems.init((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)event.getRegistry());
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityColonyBuilding.class, (ResourceLocation)new ResourceLocation("minecolonies", "colonybuilding"));
        GameRegistry.registerTileEntity(ScarecrowTileEntity.class, (ResourceLocation)new ResourceLocation("minecolonies", "scarecrow"));
        GameRegistry.registerTileEntity(TileEntityWareHouse.class, (ResourceLocation)new ResourceLocation("minecolonies", "warehouse"));
        GameRegistry.registerTileEntity(TileEntityRack.class, (ResourceLocation)new ResourceLocation("minecolonies", "rack"));
        GameRegistry.registerTileEntity(TileEntityInfoPoster.class, (ResourceLocation)new ResourceLocation("minecolonies", "infoposter"));
        GameRegistry.registerTileEntity(TileEntityBarrel.class, (ResourceLocation)new ResourceLocation("minecolonies", "barrel"));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MineColonies.instance, (IGuiHandler)new GuiHandler());
    }

    @Override
    public void registerEvents() {
    }

    @Override
    public void registerEntities() {
        ResourceLocation locationCitizen = new ResourceLocation("minecolonies", "Citizen");
        ResourceLocation locationFishHook = new ResourceLocation("minecolonies", "Fishhook");
        EntityRegistry.registerModEntity((ResourceLocation)locationCitizen, EntityCitizen.class, (String)"Citizen", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)locationFishHook, EntityFishHook.class, (String)"Fishhook", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.BARBARIAN, EntityBarbarian.class, (String)"Barbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.ARCHER, EntityArcherBarbarian.class, (String)"ArcherBarbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.CHIEF, EntityChiefBarbarian.class, (String)"ChiefBarbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.PIRATE, EntityPirate.class, (String)"Pirate", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.PIRATE_ARCHER, EntityArcherPirate.class, (String)"ArcherPirate", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)ColonyConstants.PIRATE_CHIEF, EntityCaptainPirate.class, (String)"ChiefPirate", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        LootTableList.func_186375_a((ResourceLocation)EntityBarbarian.LOOT_TABLE);
        LootTableList.func_186375_a((ResourceLocation)EntityArcherBarbarian.LOOT_TABLE);
        LootTableList.func_186375_a((ResourceLocation)EntityChiefBarbarian.LOOT_TABLE);
        LootTableList.func_186375_a((ResourceLocation)EntityPirate.LOOT_TABLE);
        LootTableList.func_186375_a((ResourceLocation)EntityArcherPirate.LOOT_TABLE);
        LootTableList.func_186375_a((ResourceLocation)EntityCaptainPirate.LOOT_TABLE);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.BARBARIAN, (int)5, (int)700);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.ARCHER, (int)5, (int)700);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.CHIEF, (int)5, (int)700);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.PIRATE, (int)7, (int)600);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.PIRATE_ARCHER, (int)7, (int)600);
        EntityRegistry.registerEgg((ResourceLocation)ColonyConstants.PIRATE_CHIEF, (int)7, (int)600);
    }

    @Override
    public void registerEntityRendering() {
    }

    @Override
    public void registerTileEntityRendering() {
    }

    @Override
    public void showCitizenWindow(CitizenDataView citizen) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation, WindowBuildTool.FreeMode mode) {
    }

    @Override
    public void openClipBoardWindow(int colonyId) {
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos pos) {
    }

    @Override
    public void registerRenderer() {
    }

    @Override
    public File getSchematicsFolder() {
        return null;
    }

    @Override
    @Nullable
    public World getWorldFromMessage(@NotNull MessageContext context) {
        return context.getServerHandler().field_147369_b.func_71121_q();
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
    }

    private int getNextEntityId() {
        return this.nextEntityId++;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull EntityPlayer player) {
        return ((EntityPlayerMP)player).func_192037_E();
    }
}

