/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewCitizenViewMessage
extends AbstractMessage<ColonyViewCitizenViewMessage, IMessage> {
    private int colonyId;
    private int citizenId;
    private ByteBuf citizenBuffer;

    public ColonyViewCitizenViewMessage() {
    }

    public ColonyViewCitizenViewMessage(@NotNull Colony colony, @NotNull CitizenData citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen.getId();
        this.citizenBuffer = Unpooled.buffer();
        citizen.serializeViewNetworkData(this.citizenBuffer);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.citizenBuffer = buf.retain();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.writeBytes(this.citizenBuffer);
    }

    @Override
    protected void messageOnClientThread(ColonyViewCitizenViewMessage message, MessageContext ctx) {
        ColonyManager.handleColonyViewCitizensMessage(message.colonyId, message.citizenId, message.citizenBuffer, Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
    }
}

