/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class AddRemoveRecipeMessage
extends AbstractMessage<AddRemoveRecipeMessage, IMessage> {
    private int colonyId;
    private boolean remove;
    private IRecipeStorage storage;
    private BlockPos building;
    private int dimension;

    public AddRemoveRecipeMessage(List<ItemStack> input, int gridSize, ItemStack primaryOutput, AbstractBuildingView building, boolean remove) {
        this.storage = gridSize == 1 ? (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.field_150460_al}) : (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput});
        this.remove = remove;
        this.dimension = building.getColony().getDimension();
        this.building = building.getLocation();
        this.colonyId = building.getColony().getID();
    }

    public AddRemoveRecipeMessage() {
    }

    public AddRemoveRecipeMessage(IRecipeStorage data, AbstractBuildingView building, boolean remove) {
        this.storage = data;
        this.remove = remove;
        this.building = building.getLocation();
        this.colonyId = building.getColony().getID();
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.storage = (IRecipeStorage)StandardFactoryController.getInstance().readFromBuffer(buf);
        this.remove = buf.readBoolean();
        this.building = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        StandardFactoryController.getInstance().writeToBuffer(buf, this.storage);
        buf.writeBoolean(this.remove);
        BlockPosUtil.writeToByteBuf(buf, this.building);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(AddRemoveRecipeMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null || !colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        AbstractBuilding buildingWorker = colony.getBuildingManager().getBuilding(message.building);
        if (buildingWorker instanceof AbstractBuildingWorker) {
            IToken token = ColonyManager.getRecipeManager().checkOrAddRecipe(message.storage);
            if (message.remove) {
                ((AbstractBuildingWorker)buildingWorker).removeRecipe(token);
            } else if (!((AbstractBuildingWorker)buildingWorker).addRecipe(token)) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.recipe.unable", ((AbstractBuildingWorker)buildingWorker).getJobName());
            } else {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.gui.recipe.done", new Object[0]);
            }
            buildingWorker.markDirty();
        }
    }
}

