/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintRenderHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private static final List<BlockPos> colonyBorder = new ArrayList<BlockPos>();
    private static final int SECONDS_TO_SHOW = 5;
    private static final int BORDER_BLOCK_INTERVAL = 3;
    private CitizenDataView citizen = null;
    private double ticksPassed = 0.0;
    private Blueprint wayPointTemplate;
    private Blueprint colonyBorderTemplate;
    private Blueprint partolPointTemplate;
    private ColonyView view = null;

    @SubscribeEvent
    public void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Pathfinding.debugDraw(event.getPartialTicks());
        Structure structure = Settings.instance.getActiveStructure();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
            if (Settings.instance.getStructureName() != null && Settings.instance.getStructureName().contains("infrastructure")) {
                ColonyView tempView = ColonyManager.getClosestColonyView((World)world, player.func_180425_c());
                if (tempView != null) {
                    if (this.wayPointTemplate == null) {
                        this.wayPointTemplate = new Structure(null, "schematics/infrastructure/Waypoint", settings).getBluePrint();
                    }
                    BlueprintRenderHandler.getInstance().drawBlueprintAtListOfPositions(new ArrayList<BlockPos>(tempView.getWayPoints()), event.getPartialTicks(), this.wayPointTemplate);
                }
            } else {
                ColonyView tempView = ColonyManager.getClosestColonyView((World)world, player.func_180425_c());
                if (tempView != null) {
                    if (colonyBorder.isEmpty() || this.view == null || !tempView.getCenter().equals((Object)this.view.getCenter())) {
                        this.calculateColonyBorder(world, tempView);
                    }
                    this.view = tempView;
                    if (this.colonyBorderTemplate == null) {
                        this.colonyBorderTemplate = new Structure(null, "schematics/infrastructure/BorderBlock", settings).getBluePrint();
                    }
                }
                if (!colonyBorder.isEmpty() && this.colonyBorderTemplate != null) {
                    BlueprintRenderHandler.getInstance().drawBlueprintAtListOfPositions(colonyBorder, event.getPartialTicks(), this.colonyBorderTemplate);
                }
            }
            return;
        }
        if (player.func_184614_ca().func_77973_b() == ModItems.scepterGuard) {
            PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_77942_o()) {
                return;
            }
            NBTTagCompound compound = stack.func_77978_p();
            ColonyView colony = ColonyManager.getColonyView(compound.func_74762_e("id"), player.field_70170_p.field_73011_w.getDimension());
            if (colony == null) {
                return;
            }
            BlockPos guardTower = BlockPosUtil.readFromNBT(compound, "pos");
            AbstractBuildingView hut = colony.getBuilding(guardTower);
            if (this.partolPointTemplate == null) {
                this.partolPointTemplate = new Structure(null, "schematics/infrastructure/PatrolPoint", settings).getBluePrint();
            }
            if (hut instanceof AbstractBuildingGuards.View) {
                BlueprintRenderHandler.getInstance().drawBlueprintAtListOfPositions(((AbstractBuildingGuards.View)hut).getPatrolTargets().stream().map(BlockPos::func_177984_a).collect(Collectors.toList()), event.getPartialTicks(), this.partolPointTemplate);
            }
        } else {
            if (this.citizen != null) {
                Entity entityCitizen = world.func_73045_a(this.citizen.getEntityId());
                if (entityCitizen instanceof EntityCitizen) {
                    this.ticksPassed += (double)event.getPartialTicks();
                    if (this.ticksPassed > 100.0) {
                        this.ticksPassed = 0.0;
                        this.citizen = null;
                    }
                } else {
                    this.citizen = null;
                    this.ticksPassed = 0.0;
                }
                return;
            }
            ColonyView colony = ColonyManager.getClosestColonyView((World)world, player.func_180425_c());
            if (colony != null && player != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
                for (CitizenDataView citizenDataView : new ArrayList<CitizenDataView>(colony.getCitizens().values())) {
                    Entity entityCitizen = world.func_73045_a(citizenDataView.getEntityId());
                    if (!(entityCitizen instanceof EntityCitizen) || !(entityCitizen.func_180425_c().func_177951_i((Vec3i)player.func_180425_c()) <= 2.0)) continue;
                    this.citizen = citizenDataView;
                    return;
                }
            }
        }
        colonyBorder.clear();
    }

    private void calculateColonyBorder(WorldClient world, ColonyView view) {
        Chunk chunk = world.func_175726_f(view.getCenter());
        BlockPos center = new BlockPos(chunk.field_76635_g * 16 + 8, view.getCenter().func_177956_o(), chunk.field_76647_h * 16 + 8);
        int range = Configurations.gameplay.workingRangeTownHallChunks * 16 + 8;
        for (int i = 0; i < (Configurations.gameplay.workingRangeTownHallChunks * 2 + 1) * 16; ++i) {
            if (i % 3 != 0) continue;
            colonyBorder.add(BlockPosUtil.findLand(new BlockPos(center.func_177958_n() - range + i, center.func_177956_o(), center.func_177952_p() + range - 1), (World)world).func_177984_a());
            colonyBorder.add(BlockPosUtil.findLand(new BlockPos(center.func_177958_n() - range + i, center.func_177956_o(), center.func_177952_p() - range), (World)world).func_177984_a());
            colonyBorder.add(BlockPosUtil.findLand(new BlockPos(center.func_177958_n() + range - 1, center.func_177956_o(), center.func_177952_p() - range + i), (World)world).func_177984_a());
            colonyBorder.add(BlockPosUtil.findLand(new BlockPos(center.func_177958_n() - range, center.func_177956_o(), center.func_177952_p() - range + i), (World)world).func_177984_a());
        }
    }
}

