/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CitizenInventoryHandler {
    private final EntityCitizen citizen;

    public CitizenInventoryHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public int findFirstSlotInInventoryWith(Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), targetItem, itemDamage);
    }

    public int findFirstSlotInInventoryWith(Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), block, itemDamage);
    }

    public int getItemCountInInventory(Block block, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), block, itemDamage);
    }

    public int getItemCountInInventory(Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), targetItem, itemDamage);
    }

    public boolean hasItemInInventory(Block block, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), block, itemDamage);
    }

    public boolean hasItemInInventory(Item item, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), item, itemDamage);
    }

    public void onInventoryChanged() {
        AbstractBuildingWorker building;
        if (this.citizen.getCitizenData() != null && (building = this.citizen.getCitizenData().getWorkBuilding()) != null) {
            building.markDirty();
        }
    }

    public boolean isInventoryFull() {
        return InventoryUtils.isProviderFull((ICapabilityProvider)this.citizen);
    }
}

