/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine;

import com.minecolonies.coremod.entity.ai.statemachine.basestatemachine.BasicStateMachine;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class TickRateStateMachine
extends BasicStateMachine<TickingTransition> {
    private int tickCounter = 0;

    public TickRateStateMachine(@NotNull IAIState initialState, @NotNull Consumer<RuntimeException> exceptionHandler) {
        super(initialState, exceptionHandler);
        this.eventTransitionMap.put(AIBlockingEventType.AI_BLOCKING, new ArrayList());
        this.eventTransitionMap.put(AIBlockingEventType.STATE_BLOCKING, new ArrayList());
        this.eventTransitionMap.put(AIBlockingEventType.EVENT, new ArrayList());
    }

    @Override
    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter > 500) {
            this.tickCounter = 1;
        }
        if (!this.transitionMap.containsKey(this.getState())) {
            this.onException(new RuntimeException("Missing AI transition for state: " + this.getState()));
            this.reset();
            return;
        }
        if (!(((ArrayList)this.eventTransitionMap.get(AIBlockingEventType.AI_BLOCKING)).stream().anyMatch(this::checkTransition) || ((ArrayList)this.eventTransitionMap.get(AIBlockingEventType.EVENT)).stream().anyMatch(this::checkTransition) || ((ArrayList)this.eventTransitionMap.get(AIBlockingEventType.STATE_BLOCKING)).stream().anyMatch(this::checkTransition))) {
            ((ArrayList)this.transitionMap.get(this.getState())).stream().anyMatch(this::checkTransition);
        }
    }

    @Override
    public boolean checkTransition(@NotNull TickingTransition transition) {
        if (this.tickCounter % transition.getTickRate() != transition.getTickOffset()) {
            return false;
        }
        return super.checkTransition(transition);
    }
}

