/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIFight;
import com.minecolonies.coremod.entity.ai.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard>
extends AbstractEntityAIFight<J> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 50;
    private static final int MAX_FOLLOW_DERIVATION = 20;
    private static final int MAX_GUARD_DERIVATION = 10;
    private static final int STOP_PERSECUTION_AFTER = 200;
    protected int currentAttackDelay = 0;
    private int lastSeen = 0;
    protected EntityLivingBase target = null;
    private BlockPos currentPatrolPoint = null;
    protected final AbstractBuildingGuards buildingGuards;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.DECIDE, this::decide), new AITarget((IAIState)AIWorkerState.GUARD_PATROL, this::patrol), new AITarget((IAIState)AIWorkerState.GUARD_FOLLOW, this::follow), new AITarget((IAIState)AIWorkerState.GUARD_GUARD, this::guard), new AITarget((IAIState)AIWorkerState.GUARD_REGEN, this::regen));
        this.buildingGuards = (AbstractBuildingGuards)this.getOwnBuilding();
    }

    private IAIState regen() {
        this.setDelay(5);
        if (this.walkToBuilding() || (double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.5 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            return this.getState();
        }
        return AIWorkerState.START_WORKING;
    }

    public abstract IAIState getAttackState();

    private IAIState guard() {
        this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
        return AIWorkerState.DECIDE;
    }

    private IAIState follow() {
        this.worker.func_70690_d(new PotionEffect(Constants.GLOW_EFFECT, 600, 20));
        this.world.func_96441_U().func_151392_a(this.worker.func_70005_c_(), "teamcolony" + this.worker.getCitizenColonyHandler().getColonyId());
        if (BlockPosUtil.getDistance2D(this.worker.func_180425_c(), this.buildingGuards.getPlayerToFollow()) > 20L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.field_70170_p, this.buildingGuards.getPlayerToFollow());
            return AIWorkerState.DECIDE;
        }
        if (this.buildingGuards.isTightGrouping()) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPlayerToFollow(), 8);
        } else if (!this.isWithinPersecutionDistance(this.buildingGuards.getPlayerToFollow())) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
        } else {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPlayerToFollow(), 20);
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState patrol() {
        if (this.currentPatrolPoint == null) {
            this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(null);
        }
        if (this.currentPatrolPoint != null && (this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2) || this.worker.getCitizenStuckHandler().isStuck())) {
            this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(this.currentPatrolPoint);
        }
        return AIWorkerState.DECIDE;
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    @Override
    protected abstract int getAttackRange();

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.getOwnBuilding(AbstractBuildingGuards.class).getTask() == GuardTask.FOLLOW || this.target != null ? Integer.MAX_VALUE : 5 * ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel();
    }

    protected IAIState decide() {
        this.setDelay(20);
        for (ToolType toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)new InvWrapper((IInventory)this.getInventory()), toolType, 0, this.buildingGuards.getMaxToolLevel())) continue;
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        this.checkForTarget();
        if (this.target != null) {
            if (this.worker.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v) > (double)(this.getAttackRange() * this.getAttackRange())) {
                this.worker.isWorkerAtSiteWithMove(this.target.func_180425_c(), this.getAttackRange());
                this.setDelay(5);
                return AIWorkerState.DECIDE;
            }
            this.setDelay(0);
            return this.getAttackState();
        }
        this.setDelay(5);
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.patrol();
            }
            case GUARD: {
                return this.guard();
            }
            case FOLLOW: {
                return this.follow();
            }
        }
        this.worker.isWorkerAtSiteWithMove(this.worker.getCitizenColonyHandler().getWorkBuilding().getLocation(), 3);
        return AIWorkerState.DECIDE;
    }

    private void checkForTarget() {
        if (this.target != null && this.target.field_70128_L) {
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.target = null;
        }
        this.target = this.getTarget();
    }

    public IAIState preAttackChecks() {
        if (!this.hasMainWeapon()) {
            this.target = null;
            return AIWorkerState.START_WORKING;
        }
        if ((double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.2 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            this.target = null;
            this.setDelay(5);
            return AIWorkerState.GUARD_REGEN;
        }
        if (this.worker.func_70643_av() != null && !this.worker.func_70643_av().field_70128_L && this.isInAttackDistance(this.worker.func_70643_av().func_180425_c())) {
            this.target = this.worker.func_70643_av();
        }
        if (this.target == null || this.target.field_70128_L || !this.isWithinPersecutionDistance(this.target.func_180425_c())) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            return AIWorkerState.DECIDE;
        }
        this.wearWeapon();
        return this.getState();
    }

    public abstract boolean hasMainWeapon();

    protected EntityLivingBase getTarget() {
        this.reduceAttackDelay(1);
        Colony colony = this.worker.getCitizenColonyHandler().getColony();
        if (this.worker.func_110144_aD() != null && !this.worker.func_110144_aD().field_70128_L) {
            if (this.isInAttackDistance(this.worker.func_110144_aD().func_180425_c())) {
                this.worker.func_130011_c(null);
            }
            this.target = this.worker.func_110144_aD();
        }
        if (this.target != null) {
            if (!this.worker.func_70685_l((Entity)this.target) && this.lastSeen < 200) {
                this.target = null;
            } else {
                ++this.lastSeen;
                return this.target;
            }
        }
        if (colony != null) {
            if (!colony.getRaiderManager().getHorde((WorldServer)this.worker.field_70170_p).isEmpty() || colony.isColonyUnderAttack()) {
                for (CitizenData citizen : colony.getCitizenManager().getCitizens()) {
                    if (!citizen.getCitizenEntity().isPresent()) continue;
                    EntityLivingBase entity2 = citizen.getCitizenEntity().get().func_70643_av();
                    if (entity2 instanceof AbstractEntityMinecoloniesMob && this.worker.func_70685_l((Entity)entity2)) {
                        return entity2;
                    }
                    if (entity2 instanceof EntityCitizen && this.worker.func_70685_l((Entity)entity2) && ((EntityCitizen)entity2).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                        return entity2;
                    }
                    if (!(entity2 instanceof EntityPlayer) || !this.worker.func_70685_l((Entity)entity2)) continue;
                    colony.isValidAttackingPlayer((EntityPlayer)entity2);
                }
            }
            List targets = this.world.func_175647_a(EntityLivingBase.class, this.getSearchArea(), entity -> this.buildingGuards.getMobsToAttack().stream().filter(MobEntryView::hasAttack).anyMatch(mobEntry -> mobEntry.getEntityEntry().getEntityClass().isInstance(entity)));
            int closest = Integer.MAX_VALUE;
            EntityLivingBase targetEntity = null;
            for (EntityLivingBase entity3 : targets) {
                if (!this.worker.func_70685_l((Entity)entity3) || !this.isWithinPersecutionDistance(entity3.func_180425_c())) continue;
                if (entity3 instanceof EntityPlayer && (colony.getPermissions().hasPermission((EntityPlayer)entity3, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((EntityPlayer)entity3))) {
                    return entity3;
                }
                if (entity3 instanceof EntityCitizen && colony.isValidAttackingGuard((EntityCitizen)entity3)) {
                    return entity3;
                }
                int tempDistance = (int)this.worker.func_180425_c().func_177954_c(entity3.field_70165_t, entity3.field_70163_u, entity3.field_70161_v);
                if (tempDistance >= closest) continue;
                closest = tempDistance;
                targetEntity = entity3;
            }
            return targetEntity;
        }
        return null;
    }

    public abstract void wearWeapon();

    public boolean isInAttackDistance(BlockPos position) {
        return BlockPosUtil.getDistance2D(this.worker.func_180425_c(), position) > (long)this.getAttackRange() && this.isWithinPersecutionDistance(position);
    }

    public void reduceAttackDelay(int tickRate) {
        if (this.currentAttackDelay > 0) {
            this.currentAttackDelay -= tickRate;
        }
    }

    private boolean isWithinPersecutionDistance(BlockPos entityPos) {
        return BlockPosUtil.getDistance2D(this.getTaskReferencePoint(), entityPos) <= (long)(this.getPersecutionDistance() + this.getAttackRange());
    }

    public int getLevelDamage() {
        if (this.worker.getCitizenData() == null) {
            return 0;
        }
        return this.worker.getCitizenData().getLevel() / (5 + this.worker.getCitizenData().getLevel() / 15);
    }

    private BlockPos getTaskReferencePoint() {
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.currentPatrolPoint != null ? this.currentPatrolPoint : this.worker.getCurrentPosition();
            }
            case FOLLOW: {
                return this.buildingGuards.getPlayerToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return 50;
            }
            case FOLLOW: {
                return 20;
            }
        }
        return 10;
    }

    protected AxisAlignedBB getSearchArea() {
        AbstractBuildingGuards building = (AbstractBuildingGuards)this.getOwnBuilding();
        double x1 = this.worker.field_70165_t + (double)(building.getBonusVision() + 10);
        double x2 = this.worker.field_70165_t - (double)(building.getBonusVision() + 10);
        double y1 = this.worker.field_70163_u + 10.0;
        double y2 = this.worker.field_70163_u - 10.0;
        double z1 = this.worker.field_70161_v + (double)(building.getBonusVision() + 10);
        double z2 = this.worker.field_70161_v - (double)(building.getBonusVision() + 10);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }
}

