/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.crusher;

import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.network.messages.CrusherParticleEffectMessage;
import com.minecolonies.coremod.util.SoundUtils;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCrusher<J extends AbstractJobCrafter>
extends AbstractEntityAICrafting<JobCrusher> {
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int ENDURANCE_MULTIPLIER = 1;
    private static final int TICK_DELAY = 5;

    public EntityAIWorkCrusher(@NotNull JobCrusher job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.CRUSH, this::crush));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getEndurance());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingCrusher.class;
    }

    @Override
    protected IAIState decide() {
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        return AIWorkerState.CRUSH;
    }

    protected IAIState crush() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        WorkerUtil.faceBlock(((AbstractSchematicProvider)this.getOwnBuilding()).getLocation(), this.worker);
        this.setDelay(5);
        ++this.progress;
        BuildingCrusher crusherBuilding = this.getOwnBuilding(BuildingCrusher.class);
        if (this.currentRecipeStorage == null) {
            this.currentRecipeStorage = crusherBuilding.getCurrentRecipe();
        }
        if (this.getState() != AIWorkerState.CRAFT && crusherBuilding.getCurrentDailyQuantity() >= (Integer)crusherBuilding.getCrusherMode().func_76340_b()) {
            return AIWorkerState.START_WORKING;
        }
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (this.progress > 50 - Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50)) {
            this.progress = 0;
            if (check == AIWorkerState.CRAFT) {
                if (this.getState() != AIWorkerState.CRAFT) {
                    crusherBuilding.setCurrentDailyQuantity(crusherBuilding.getCurrentDailyQuantity() + 1);
                    if (crusherBuilding.getCurrentDailyQuantity() >= (Integer)crusherBuilding.getCrusherMode().func_76340_b()) {
                        this.incrementActionsDoneAndDecSaturation();
                    }
                }
                ++this.craftCounter;
                this.currentRecipeStorage.fullFillRecipe(this.worker.getItemHandlerCitizen());
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenExperienceHandler().addExperience(0.1);
            } else {
                if (this.getState() != AIWorkerState.CRAFT) {
                    this.currentRecipeStorage = crusherBuilding.getCurrentRecipe();
                    int requestQty = Math.min(((Integer)crusherBuilding.getCrusherMode().func_76340_b() - crusherBuilding.getCurrentDailyQuantity()) * 2, 64);
                    if (requestQty <= 0) {
                        return AIWorkerState.START_WORKING;
                    }
                    ItemStack stack = this.currentRecipeStorage.getInput().get(0).func_77946_l();
                    stack.func_190920_e(requestQty);
                    this.checkIfRequestForItemExistOrCreateAsynch(stack);
                    return AIWorkerState.START_WORKING;
                }
                return check;
            }
        }
        if (check == AIWorkerState.CRAFT) {
            MineColonies.getNetwork().sendToAllTracking((IMessage)new CrusherParticleEffectMessage(this.currentRecipeStorage.getInput().get(0).func_77946_l(), crusherBuilding.getID()), (Entity)this.worker);
            SoundUtils.playSoundAtCitizen(this.world, ((AbstractSchematicProvider)this.getOwnBuilding()).getID(), SoundEvents.field_187835_fT);
        }
        return this.getState();
    }

    @Override
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.maxCraftingCount == 0) {
            this.maxCraftingCount = CraftingUtils.calculateMaxCraftingCount(((JobCrusher)this.job).getCurrentTask().getRequest().getCount(), this.currentRecipeStorage);
        }
        if (this.maxCraftingCount == 0) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getRequestManager().updateRequestState((IToken<?>)((JobCrusher)this.job).getCurrentTask().getToken(), RequestState.CANCELLED);
            this.maxCraftingCount = 0;
            this.craftCounter = 0;
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = ((JobCrusher)this.job).getCurrentTask();
        IAIState nextState = this.crush();
        if (nextState == this.getState()) {
            if (this.craftCounter >= this.maxCraftingCount) {
                ItemStack primaryOutput = this.currentRecipeStorage.getPrimaryOutput();
                primaryOutput.func_190920_e(((PublicCrafting)this.currentRequest.getRequest()).getCount());
                this.currentRequest.addDelivery(primaryOutput);
                this.incrementActionsDoneAndDecSaturation();
                this.maxCraftingCount = 0;
                this.craftCounter = 0;
                this.currentRecipeStorage = null;
                return AIWorkerState.START_WORKING;
            }
        } else {
            this.maxCraftingCount = 0;
            this.craftCounter = 0;
            return AIWorkerState.START_WORKING;
        }
        return this.getState();
    }
}

