/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIUsesFurnace<J extends AbstractJob>
extends AbstractEntityAISkill<J> {
    protected static final double BASE_XP_GAIN = 2.0;
    private static final int RETRIEVE_SMELTABLE_IF_MORE_THAN = 10;
    protected static final int WAIT_AFTER_REQUEST = 50;

    protected AbstractEntityAIUsesFurnace(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorking), new AITarget((IAIState)AIWorkerState.START_USING_FURNACE, this::fillUpFurnace), new AITarget((IAIState)AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveSmeltableFromFurnace));
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingFurnaceUser.class;
    }

    protected abstract void extractFromFurnace(TileEntityFurnace var1);

    protected abstract boolean isSmeltable(ItemStack var1);

    protected boolean reachedMaxToKeep() {
        return false;
    }

    protected BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces()) {
            int countInResultSlot;
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityFurnace)) continue;
            TileEntityFurnace furnace = (TileEntityFurnace)entity;
            int n = countInResultSlot = ItemStackUtils.isEmpty(furnace.func_70301_a(2)) != false ? 0 : furnace.func_70301_a(2).func_190916_E();
            if ((furnace.func_145950_i() || countInResultSlot <= 0) && countInResultSlot <= 10) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return pos;
        }
        return null;
    }

    private IAIState startWorking() {
        if (this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        if (this.getOwnBuilding(AbstractBuildingFurnaceUser.class).getCopyOfAllowedItems().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.furnaceUser.noFuel", new Object[0]);
            return this.getState();
        }
        if (this.getOwnBuilding(AbstractBuildingFurnaceUser.class).getFurnaces().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.baker.noFurnace", new Object[0]);
            return this.getState();
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.deciding", new Object[0])});
        IAIState nextState = this.checkForImportantJobs();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        int amountOfSmeltableInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), this::isSmeltable);
        int amountOfSmeltableInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this::isSmeltable);
        int amountOfFuelInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), TileEntityFurnace::func_145954_b);
        int amountOfFuelInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b);
        if (amountOfSmeltableInBuilding + amountOfSmeltableInInv <= 0 && !((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(this.getSmeltAbleClass().getClass())) && !this.reachedMaxToKeep()) {
            this.worker.getCitizenData().createRequestAsync(this.getSmeltAbleClass());
        } else if (amountOfFuelInBuilding + amountOfFuelInInv <= 0 && !((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(StackList.class))) {
            this.worker.getCitizenData().createRequestAsync(new StackList(this.getOwnBuilding(AbstractBuildingFurnaceUser.class).getAllowedFuel(), "com.minecolonies.coremod.request.burnable"));
        }
        if (amountOfSmeltableInBuilding > 0 && amountOfSmeltableInInv == 0) {
            this.needsCurrently = this::isSmeltable;
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (amountOfFuelInBuilding > 0 && amountOfFuelInInv == 0) {
            this.needsCurrently = TileEntityFurnace::func_145954_b;
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.checkIfAbleToSmelt(amountOfFuelInBuilding + amountOfFuelInInv, amountOfSmeltableInBuilding + amountOfSmeltableInInv);
    }

    private IAIState checkIfAbleToSmelt(int amountOfFuel, int amountOfSmeltable) {
        for (BlockPos pos : ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityFurnace) || ((TileEntityFurnace)entity).func_145950_i()) continue;
            TileEntityFurnace furnace = (TileEntityFurnace)entity;
            if (!(amountOfFuel > 0 && ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || amountOfSmeltable > 0 && ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace)) && (amountOfFuel <= 0 || amountOfSmeltable <= 0 || !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) continue;
            this.walkTo = pos;
            return AIWorkerState.START_USING_FURNACE;
        }
        return this.checkForAdditionalJobs();
    }

    protected IAIState checkForAdditionalJobs() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.idling", new Object[0])});
        this.setDelay(50);
        return AIWorkerState.START_WORKING;
    }

    protected IAIState checkForImportantJobs() {
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState retrieveSmeltableFromFurnace() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            this.setDelay(2);
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof TileEntityFurnace) || ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromFurnace((TileEntityFurnace)entity);
        this.incrementActionsDoneAndDecSaturation();
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState fillUpFurnace() {
        if (((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.status.cooking", new Object[0]);
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkTo == null || this.world.func_180495_p(this.walkTo).func_177230_c() != Blocks.field_150460_al) {
            this.walkTo = null;
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            this.setDelay(2);
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (entity instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this::isSmeltable) && (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this::isSmeltable, 64, (IItemHandler)new InvWrapper((IInventory)furnace), 0);
            }
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b) && (ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b, 64, (IItemHandler)new InvWrapper((IInventory)furnace), 1);
            }
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    protected abstract IRequestable getSmeltAbleClass();
}

