/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAICrafting<J extends AbstractJobCrafter>
extends AbstractEntityAIInteract<J> {
    protected static final int HIT_DELAY = 20;
    public static final int PROGRESS_MULTIPLIER = 50;
    protected static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 3;
    protected IRecipeStorage currentRecipeStorage;
    protected int maxCraftingCount = 0;
    protected int craftCounter = 0;
    protected int progress = 0;
    protected IRequest<? extends PublicCrafting> currentRequest;

    public AbstractEntityAICrafting(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, this::decide), new AITarget((IAIState)AIWorkerState.QUERY_ITEMS, this::queryItems), new AITarget((IAIState)AIWorkerState.GET_RECIPE, this::getRecipe), new AITarget((IAIState)AIWorkerState.CRAFT, this::craft));
        this.worker.func_98053_h(true);
    }

    protected IAIState decide() {
        if (((AbstractJobCrafter)this.job).getTaskQueue().isEmpty()) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState getRecipe() {
        IRequest<? extends PublicCrafting> currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            return AIWorkerState.START_WORKING;
        }
        Object buildingWorker = this.getOwnBuilding();
        this.currentRecipeStorage = ((AbstractBuildingWorker)buildingWorker).getFirstFullFillableRecipe(currentTask.getRequest().getStack());
        if (this.currentRecipeStorage == null) {
            this.worker.getCitizenColonyHandler().getColony().getRequestManager().updateRequestState((IToken<?>)currentTask.getToken(), RequestState.CANCELLED);
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        this.setDelay(5);
        return AIWorkerState.QUERY_ITEMS;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState queryItems() {
        this.setDelay(5);
        if (this.currentRecipeStorage == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        return this.checkForItems(this.currentRecipeStorage);
    }

    protected IAIState checkForItems(IRecipeStorage storage) {
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack).matches(inputStorage.getItemStack());
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), predicate)) continue;
            if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), predicate)) {
                this.needsCurrently = predicate;
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.currentRecipeStorage = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.maxCraftingCount == 0) {
            this.maxCraftingCount = CraftingUtils.calculateMaxCraftingCount(((AbstractJobCrafter)this.job).getCurrentTask().getRequest().getCount(), this.currentRecipeStorage);
        }
        if (this.maxCraftingCount == 0) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getRequestManager().updateRequestState((IToken<?>)((AbstractJobCrafter)this.job).getCurrentTask().getToken(), RequestState.CANCELLED);
            this.maxCraftingCount = 0;
            this.progress = 0;
            this.craftCounter = 0;
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        ++this.progress;
        this.worker.func_184611_a(EnumHand.MAIN_HAND, this.currentRecipeStorage.getInput().get(this.worker.getRandom().nextInt(this.currentRecipeStorage.getInput().size())).func_77946_l());
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((AbstractSchematicProvider)this.getOwnBuilding()).getLocation());
        this.setDelay(20);
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.progress >= this.getRequiredProgressForMakingRawMaterial()) {
            IAIState check = this.checkForItems(this.currentRecipeStorage);
            if (check == AIWorkerState.CRAFT) {
                while (this.craftCounter < this.maxCraftingCount && this.currentRequest != null) {
                    this.currentRecipeStorage.fullFillRecipe(this.worker.getItemHandlerCitizen());
                    this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
                    ++this.craftCounter;
                }
                this.incrementActionsDoneAndDecSaturation();
                this.maxCraftingCount = 0;
                this.progress = 0;
                this.craftCounter = 0;
                this.currentRecipeStorage = null;
                this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
                return AIWorkerState.START_WORKING;
            }
            return check;
        }
        return this.getState();
    }

    @Override
    public IAIState afterDump() {
        if (this.maxCraftingCount == 0 && this.progress == 0 && this.craftCounter == 0 && this.currentRequest != null) {
            ((AbstractJobCrafter)this.job).finishRequest(true);
            this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
            this.currentRequest = null;
        }
        return super.afterDump();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private int getRequiredProgressForMakingRawMaterial() {
        return 50 / Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50) * 3;
    }
}

