/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import com.minecolonies.coremod.commands.MinecoloniesCommand;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public class RandomTeleportCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "rtp";
    private static final int ATTEMPTS = Configurations.gameplay.numberOfAttemptsForSafeTP;
    private static final int UPPER_BOUNDS = Configurations.gameplay.maxDistanceFromWorldSpawn * 2;
    private static final int LOWER_BOUNDS = Configurations.gameplay.maxDistanceFromWorldSpawn;
    private static final int SPAWN_NO_TP = Configurations.gameplay.minDistanceFromWorldSpawn;
    private static final int STARTING_Y = 250;
    private static final double SAFETY_DROP = 6.0;
    private static final int FALL_DISTANCE = 5;
    private static final String CANT_FIND_PLAYER = "No player found for teleport, please define one.";

    public RandomTeleportCommand() {
        super(new String[0]);
    }

    public RandomTeleportCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "rtp<playerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        EntityPlayerMP player = actionMenuState.getPlayerForArgument("player");
        this.executeShared(server, sender, null != player ? player.func_70005_c_() : null);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        String playerName = null;
        if (args.length != 0) {
            playerName = args[0];
        }
        this.executeShared(server, sender, playerName);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String playerName) throws CommandException {
        if (SPAWN_NO_TP >= LOWER_BOUNDS) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Please have an admin raise the maxDistanceFromWorldSpawn number in config."));
            return;
        }
        if (!RandomTeleportCommand.canCommandSenderUseCommand(AbstractSingleCommand.Commands.RTP) || sender.func_130014_f_().field_73011_w.getDimension() != 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Not happenin bro!!, ask an OP to TP you."));
            return;
        }
        EntityPlayer playerToTeleport = null;
        if (sender instanceof EntityPlayer) {
            playerToTeleport = (EntityPlayer)sender;
        }
        if (null != playerName && RandomTeleportCommand.isPlayerOpped(sender)) {
            World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
            playerToTeleport = ServerUtils.getPlayerFromUUID(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(playerName).getId(), world);
            sender.func_145747_a((ITextComponent)new TextComponentString("TPing Player: " + playerToTeleport.func_70005_c_()));
        }
        if (playerToTeleport == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(CANT_FIND_PLAYER));
            return;
        }
        RandomTeleportCommand.teleportPlayer(sender, playerToTeleport);
    }

    private static void teleportPlayer(ICommandSender sender, EntityPlayer playerToTeleport) {
        for (int attCounter = 0; attCounter <= ATTEMPTS; ++attCounter) {
            boolean foundPosition;
            BlockPos groundPosition;
            int x = RandomTeleportCommand.getRandCoordinate();
            int z = RandomTeleportCommand.getRandCoordinate();
            if ((double)sender.func_130014_f_().func_175723_af().func_177722_l() < sender.func_130014_f_().func_175694_M().func_185332_f(x, sender.func_130014_f_().func_175694_M().func_177956_o(), z)) continue;
            BlockPos tpPos = new BlockPos(x, 250, z);
            Colony colony = ColonyManager.getClosestColony(sender.func_130014_f_(), tpPos);
            if (colony != null && BlockPosUtil.getDistance2D(colony.getCenter(), tpPos) < (long)(Configurations.gameplay.workingRangeTownHall * 2 + Configurations.gameplay.townHallPadding) || (groundPosition = BlockPosUtil.findLand(tpPos, sender.func_130014_f_())) == null || !(foundPosition = BlockPosUtil.isPositionSafe(sender.func_130014_f_(), groundPosition.func_177977_b()))) continue;
            if (MinecoloniesCommand.canExecuteCommand((EntityPlayer)sender)) {
                playerToTeleport.func_145747_a((ITextComponent)new TextComponentString("Buckle up buttercup, this ain't no joy ride!!!"));
                playerToTeleport.func_70606_j(playerToTeleport.func_110138_aP());
                playerToTeleport.func_70634_a((double)groundPosition.func_177958_n(), (double)groundPosition.func_177956_o() + 6.0, (double)groundPosition.func_177952_p());
                playerToTeleport.func_70606_j(playerToTeleport.func_110138_aP());
                playerToTeleport.field_70143_R = -5.0f;
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Please wait at least " + Configurations.gameplay.teleportBuffer + " seconds to teleport again"));
            }
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Couldn't find a safe spot.  Try again in a moment."));
    }

    private static int getRandCoordinate() {
        Random rnd = new Random();
        int x = rnd.nextInt(UPPER_BOUNDS) - LOWER_BOUNDS;
        while (x > -SPAWN_NO_TP && x < SPAWN_NO_TP) {
            x = rnd.nextInt(UPPER_BOUNDS) - LOWER_BOUNDS;
        }
        return x;
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0;
    }
}

