/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class DoRaidTonightCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "raid-tonight";
    private static final TextComponentString NO_COLONY_FOUND_MESSAGE = new TextComponentString("No Colony found.");
    private static final TextComponentString NO_ARGUMENTS = new TextComponentString("Please define a colony to raid tonight.");
    private static final TextComponentString SUCCESSFUL = new TextComponentString("Command Successful");

    public DoRaidTonightCommand() {
        super(new String[0]);
    }

    public DoRaidTonightCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Colony colony = actionMenuState.getColonyForArgument("colony");
        if (colony == null) {
            sender.func_145747_a((ITextComponent)NO_COLONY_FOUND_MESSAGE);
            return;
        }
        this.executeShared(server, sender, colony);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        Colony colony = null;
        if (args.length != 0) {
            colony = ColonyManager.getColonyByWorld(Integer.parseInt(args[0]), (World)server.func_71218_a(0));
            if (colony == null) {
                sender.func_145747_a((ITextComponent)NO_COLONY_FOUND_MESSAGE);
                return;
            }
        } else {
            sender.func_145747_a((ITextComponent)NO_ARGUMENTS);
            return;
        }
        this.executeShared(server, sender, colony);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @Nullable Colony colony) {
        if (sender instanceof EntityPlayer && !DoRaidTonightCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        colony.getRaiderManager().setWillRaidTonight(true);
        sender.func_145747_a((ITextComponent)SUCCESSFUL);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DoRaidTonightCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

