/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StandardRetryingRequestResolver;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class StandardRetryingRequestResolverFactory
implements IFactory<IRequestManager, StandardRetryingRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_VALUE = "Value";
    private static final String NBT_TRIES = "Requests";
    private static final String NBT_DELAYS = "Delays";

    @Override
    @NotNull
    public TypeToken<? extends StandardRetryingRequestResolver> getFactoryOutputType() {
        return TypeToken.of(StandardRetryingRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends IRequestManager> getFactoryInputType() {
        return TypeToken.of(IRequestManager.class);
    }

    @Override
    @NotNull
    public StandardRetryingRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull IRequestManager iRequestManager, Object ... context) throws IllegalArgumentException {
        if (context.length != 0) {
            throw new IllegalArgumentException("Context is not empty.");
        }
        return new StandardRetryingRequestResolver(factoryController, iRequestManager);
    }

    @Override
    @NotNull
    public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRetryingRequestResolver standardRetryingRequestResolver) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_TRIES, (NBTBase)standardRetryingRequestResolver.getAssignedRequests().keySet().stream().map(t -> {
            NBTTagCompound assignmentCompound = new NBTTagCompound();
            assignmentCompound.func_74782_a(NBT_TOKEN, (NBTBase)controller.serialize(t));
            assignmentCompound.func_74768_a(NBT_VALUE, standardRetryingRequestResolver.getAssignedRequests().get(t).intValue());
            return assignmentCompound;
        }).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a(NBT_DELAYS, (NBTBase)standardRetryingRequestResolver.getDelays().keySet().stream().map(t -> {
            NBTTagCompound delayCompound = new NBTTagCompound();
            delayCompound.func_74782_a(NBT_TOKEN, (NBTBase)controller.serialize(t));
            delayCompound.func_74768_a(NBT_VALUE, standardRetryingRequestResolver.getDelays().get(t).intValue());
            return delayCompound;
        }).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a(NBT_TOKEN, (NBTBase)controller.serialize(standardRetryingRequestResolver.getRequesterId()));
        compound.func_74782_a(NBT_LOCATION, (NBTBase)controller.serialize(standardRetryingRequestResolver.getRequesterLocation()));
        return compound;
    }

    @Override
    @NotNull
    public StandardRetryingRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
        Map<IToken<?>, Integer> assignments = NBTUtils.streamCompound(nbt.func_150295_c(NBT_TRIES, 10)).map(assignmentCompound -> {
            IToken token = (IToken)controller.deserialize(assignmentCompound.func_74775_l(NBT_TOKEN));
            Integer tries = assignmentCompound.func_74762_e(NBT_VALUE);
            return new AbstractMap.SimpleEntry<IToken, Integer>(token, tries);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        Map<IToken<?>, Integer> delays = NBTUtils.streamCompound(nbt.func_150295_c(NBT_DELAYS, 10)).map(assignmentCompound -> {
            IToken token = (IToken)controller.deserialize(assignmentCompound.func_74775_l(NBT_TOKEN));
            Integer tries = assignmentCompound.func_74762_e(NBT_VALUE);
            return new AbstractMap.SimpleEntry<IToken, Integer>(token, tries);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        StandardRetryingRequestResolver retryingRequestResolver = new StandardRetryingRequestResolver(token, location);
        retryingRequestResolver.updateData(assignments, delays);
        return retryingRequestResolver;
    }
}

