/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingProductionResolver<C extends AbstractCrafting>
extends AbstractRequestResolver<C>
implements IBuildingBasedRequester {
    private final Class<C> cClass;

    public AbstractCraftingProductionResolver(@NotNull ILocation location, @NotNull IToken<?> token, Class<C> cClass) {
        super(location, token);
        this.cClass = cClass;
    }

    @Override
    public TypeToken<? extends C> getRequestType() {
        return TypeToken.of(this.cClass);
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().field_72995_K) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getRequesterLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends C> requestToCheck) {
        if (!manager.getColony().getWorld().field_72995_K) {
            ILocation requesterLocation = requestToCheck.getRequester().getRequesterLocation();
            return requesterLocation.equals(this.getRequesterLocation());
        }
        return false;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        return this.attemptResolveForBuilding(manager, request, building);
    }

    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        return this.attemptResolveForBuildingAndStack(manager, buildingWorker, ((AbstractCrafting)request.getRequest()).getStack(), ((AbstractCrafting)request.getRequest()).getCount());
    }

    @Nullable
    protected List<IToken<?>> attemptResolveForBuildingAndStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, ItemStack stack, int count) {
        if (!this.canBuildingCraftStack(manager, building, stack)) {
            return null;
        }
        IRecipeStorage fullfillableCrafting = building.getFirstFullFillableRecipe(stack);
        if (fullfillableCrafting != null) {
            return ImmutableList.of();
        }
        IRecipeStorage craftableCrafting = building.getFirstRecipe(stack);
        if (craftableCrafting == null) {
            return null;
        }
        return this.createRequestsForRecipe(manager, building, stack, count, craftableCrafting);
    }

    protected boolean canBuildingCraftStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, @NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    protected List<IToken<?>> createRequestsForRecipe(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, ItemStack requestStack, int count, @NotNull IRecipeStorage storage) {
        int craftingCount = CraftingUtils.calculateMaxCraftingCount(count, storage);
        return storage.getCleanedInput().stream().filter(s -> ItemStackUtils.isEmpty(s.getItemStack()) == false).filter(s -> InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)building.getMainCitizen().getInventory()), stack -> ItemStackUtils.isEmpty(stack) == false && s.getItemStack().func_77969_a(stack)) < s.getAmount()).map(stack -> {
            ItemStack craftingHelperStack = stack.getItemStack().func_77946_l();
            ItemStackUtils.setSize(craftingHelperStack, stack.getAmount() * craftingCount);
            return this.createNewRequestForStack(manager, craftingHelperStack);
        }).collect(Collectors.toList());
    }

    @Nullable
    protected IToken<?> createNewRequestForStack(@NotNull IRequestManager manager, ItemStack stack) {
        return manager.createRequest(this, new Stack(stack.func_77946_l()));
    }

    @Override
    public void onAssignedToThisResolver(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, boolean simulation) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        this.onAssignedToThisResolverForBuilding(manager, request, simulation, building);
    }

    protected void onAssignedToThisResolverForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, boolean simulation, @NotNull AbstractBuilding building) {
    }

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getToken()).map(r -> (AbstractBuilding)r).get();
        this.resolveForBuilding(manager, request, building);
    }

    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends C> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        IRecipeStorage storage = buildingWorker.getFirstFullFillableRecipe(((AbstractCrafting)request.getRequest()).getStack());
        if (storage == null) {
            Log.getLogger().error("Failed to craft a crafting recipe of: " + ((AbstractCrafting)request.getRequest()).getStack().toString() + ". Its ingredients are missing.");
            return;
        }
        int craftingCount = CraftingUtils.calculateMaxCraftingCount(((AbstractCrafting)request.getRequest()).getCount(), storage);
        for (int i = 0; i < craftingCount; ++i) {
            buildingWorker.fullFillRecipe(storage);
        }
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
    }
}

