/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers.interfaces;

import com.minecolonies.coremod.colony.CitizenData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICitizenManager {
    public void readFromNBT(@NotNull NBTTagCompound var1);

    public void writeToNBT(@NotNull NBTTagCompound var1);

    public void sendPackets(@NotNull Set<EntityPlayerMP> var1, boolean var2, @NotNull Set<EntityPlayerMP> var3);

    public void spawnOrCreateCitizen();

    @NotNull
    public Map<Integer, CitizenData> getCitizenMap();

    public CitizenData getCitizen(int var1);

    default public CitizenData spawnOrCreateCitizen(CitizenData data, @NotNull World world) {
        return this.spawnOrCreateCitizen(data, world, null, false);
    }

    default public CitizenData spawnOrCreateCitizen(CitizenData data, @NotNull World world, BlockPos spawnPos) {
        return this.spawnOrCreateCitizen(data, world, spawnPos, false);
    }

    public CitizenData spawnOrCreateCitizen(CitizenData var1, @NotNull World var2, BlockPos var3, boolean var4);

    public CitizenData createAndRegisterNewCitizenData();

    public void removeCitizen(@NotNull CitizenData var1);

    @Nullable
    public CitizenData getJoblessCitizen();

    public void calculateMaxCitizens();

    public void markCitizensDirty();

    public void clearDirty();

    public List<CitizenData> getCitizens();

    public int getMaxCitizens();

    public int getCurrentCitizenCount();

    public void setMaxCitizens(int var1);

    public void checkCitizensForHappiness();

    public void onWorldTick(TickEvent.WorldTickEvent var1);

    public void updateCitizenMourn(boolean var1);
}

