/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobStonemason;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class BuildingStonemason
extends AbstractBuildingCrafter {
    private static final String STONEMASON = "Stonemason";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingStonemason(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return STONEMASON;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobStonemason(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return STONEMASON;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
        if (storage == null) {
            return false;
        }
        int amountOfValidBlocks = 0;
        int blocks = 0;
        if (storage.getPrimaryOutput().func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)storage.getPrimaryOutput().func_77973_b()).func_179223_d();
            if (block == Blocks.field_150417_aV || block == Blocks.field_150390_bg || block == Blocks.field_150333_U || block == Blocks.field_180389_cP || block == Blocks.field_150348_b || block == Blocks.field_150322_A || block == Blocks.field_180395_cM) {
                return true;
            }
            if (block == Blocks.field_185772_cY) {
                return false;
            }
        }
        for (ItemStack stack : storage.getInput()) {
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            ++blocks;
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                Block block;
                if (stack.func_77973_b() instanceof ItemBlock && ((block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == Blocks.field_150417_aV || block == Blocks.field_150390_bg || block == Blocks.field_150333_U || block == Blocks.field_180389_cP)) {
                    ++amountOfValidBlocks;
                    continue;
                }
                String name = OreDictionary.getOreName((int)id);
                if (name.contains("stone")) {
                    ++amountOfValidBlocks;
                    continue;
                }
                if (!name.contains("stick") && !name.contains("wood") && !name.toLowerCase(Locale.US).contains("redstone") && !name.contains("string") && !name.contains("gunpowder")) continue;
                return false;
            }
        }
        return amountOfValidBlocks > 0 && (double)(blocks / amountOfValidBlocks) > 0.75;
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingStonemason.STONEMASON);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }
    }
}

