/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutStoneSmelter;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobStoneSmeltery;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingStoneSmeltery
extends AbstractBuildingSmelterCrafter {
    private static final String STONE_SMELTERY = "StoneSmeltery";

    public BuildingStoneSmeltery(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return STONE_SMELTERY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobStoneSmeltery(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return STONE_SMELTERY;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
        if (storage == null) {
            return false;
        }
        if (storage.getIntermediate() != Blocks.field_150460_al || storage.getInput().isEmpty()) {
            return false;
        }
        return this.isBlockForThisSmelter(storage.getPrimaryOutput()) && FurnaceRecipes.func_77602_a().func_151395_a(storage.getInput().get(0)).func_77969_a(storage.getPrimaryOutput());
    }

    public boolean isBlockForThisSmelter(ItemStack stack) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && ((block = ((ItemBlock)item).func_179223_d()) == Blocks.field_150348_b || block == Blocks.field_150417_aV || block instanceof BlockGlazedTerracotta || block instanceof BlockHardenedClay)) {
            return true;
        }
        return item == Items.field_151118_aC;
    }

    public static class View
    extends AbstractBuildingSmelterCrafter.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutStoneSmelter(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }
    }
}

