/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutCook;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.FilterableListView;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobCook;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingCook
extends AbstractBuildingFurnaceUser {
    private static final String COOK_DESC = "Cook";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingCook(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(ItemStackUtils.ISFOOD, new Tuple((Object)64, (Object)true));
        this.keepX.put(ItemStackUtils.ISCOOKABLE, new Tuple((Object)64, (Object)true));
        this.keepX.put(TileEntityFurnace::func_145954_b, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobCook(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COOK_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (ItemStackUtils.ISFOOD.test(stack) || this.getAllowedFuel().stream().anyMatch(fuelStack -> fuelStack.func_77969_a(stack))) {
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory);
    }

    public static class View
    extends FilterableListView {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCook(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

