/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowBarracksBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracks
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "Barracks";
    private static final int BARRACKS_HUT_MAX_LEVEL = 5;
    private static final String TAG_TOWERS = "towers";
    private final List<BlockPos> towers = new ArrayList<BlockPos>();

    public BuildingBarracks(@NotNull Colony colony, BlockPos pos) {
        super(colony, pos);
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onDestroyed() {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (BlockPos tower : this.towers) {
                world.func_175656_a(tower, Blocks.field_150350_a.func_176223_P());
            }
        }
        super.onDestroyed();
    }

    @Override
    public void registerBlockPosition(@NotNull IBlockState block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block.func_177230_c() == ModBlocks.blockBarracksTowerSubstitution) {
            AbstractBuilding building;
            if (world.func_180495_p(pos).func_177230_c() != ModBlocks.blockHutBarracksTower) {
                world.func_175656_a(pos, ModBlocks.blockHutBarracksTower.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, block.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
                this.getColony().getBuildingManager().addNewBuilding((TileEntityColonyBuilding)world.func_175625_s(pos), world);
            }
            if ((building = this.getColony().getBuildingManager().getBuilding(pos)) instanceof BuildingBarracksTower) {
                building.setStyle(this.getStyle());
                ((BuildingBarracksTower)building).addBarracks(this.getLocation());
                if (!this.towers.contains(pos)) {
                    this.towers.add(pos);
                }
            }
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.towers.clear();
        this.towers.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_TOWERS, 10)).map(resultCompound -> BlockPosUtil.readFromNBT(resultCompound, "pos")).collect(Collectors.toList()));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList towerTagList = this.towers.stream().map(pos -> BlockPosUtil.writeToNBT(new NBTTagCompound(), "pos", pos)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a(TAG_TOWERS, (NBTBase)towerTagList);
    }

    public static class View
    extends AbstractBuildingView {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowBarracksBuilding(this);
        }
    }
}

