/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.AssignFilterableItemMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class FilterableListView
extends AbstractBuildingWorker.View {
    private final List<ItemStorage> listOfItems = new ArrayList<ItemStorage>();

    public FilterableListView(ColonyView c, @NotNull BlockPos l) {
        super(c, l);
    }

    public void addItem(ItemStorage item) {
        MineColonies.getNetwork().sendToServer((IMessage)new AssignFilterableItemMessage(this, item, true));
        if (!this.listOfItems.contains(item)) {
            this.listOfItems.add(item);
        }
    }

    public boolean isAllowedItem(ItemStorage item) {
        return this.listOfItems.contains(item);
    }

    public void removeItem(ItemStorage item) {
        MineColonies.getNetwork().sendToServer((IMessage)new AssignFilterableItemMessage(this, item, false));
        this.listOfItems.remove(item);
    }

    @Override
    public void deserialize(@NotNull ByteBuf buf) {
        super.deserialize(buf);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.listOfItems.add(new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf)));
        }
    }
}

