/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockPostBox;
import com.minecolonies.coremod.blocks.huts.BlockHutArchery;
import com.minecolonies.coremod.blocks.huts.BlockHutBaker;
import com.minecolonies.coremod.blocks.huts.BlockHutBarracks;
import com.minecolonies.coremod.blocks.huts.BlockHutBarracksTower;
import com.minecolonies.coremod.blocks.huts.BlockHutBlacksmith;
import com.minecolonies.coremod.blocks.huts.BlockHutBuilder;
import com.minecolonies.coremod.blocks.huts.BlockHutChickenHerder;
import com.minecolonies.coremod.blocks.huts.BlockHutCitizen;
import com.minecolonies.coremod.blocks.huts.BlockHutCombatAcademy;
import com.minecolonies.coremod.blocks.huts.BlockHutComposter;
import com.minecolonies.coremod.blocks.huts.BlockHutCook;
import com.minecolonies.coremod.blocks.huts.BlockHutCowboy;
import com.minecolonies.coremod.blocks.huts.BlockHutCrusher;
import com.minecolonies.coremod.blocks.huts.BlockHutDeliveryman;
import com.minecolonies.coremod.blocks.huts.BlockHutFarmer;
import com.minecolonies.coremod.blocks.huts.BlockHutFisherman;
import com.minecolonies.coremod.blocks.huts.BlockHutGuardTower;
import com.minecolonies.coremod.blocks.huts.BlockHutLibrary;
import com.minecolonies.coremod.blocks.huts.BlockHutLumberjack;
import com.minecolonies.coremod.blocks.huts.BlockHutMiner;
import com.minecolonies.coremod.blocks.huts.BlockHutSawmill;
import com.minecolonies.coremod.blocks.huts.BlockHutShepherd;
import com.minecolonies.coremod.blocks.huts.BlockHutSmeltery;
import com.minecolonies.coremod.blocks.huts.BlockHutStoneSmeltery;
import com.minecolonies.coremod.blocks.huts.BlockHutStonemason;
import com.minecolonies.coremod.blocks.huts.BlockHutSwineHerder;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.blocks.huts.BlockHutWareHouse;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingArchery;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBlacksmith;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingChickenHerder;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCombatAcademy;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingComposter;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFisherman;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGuardTower;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSawmill;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingShepherd;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingStoneSmeltery;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingStonemason;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSwineHerder;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.ColonyUtils;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingRegistry {
    @NotNull
    private static final BiMap<String, Class<?>> nameToClassMap = HashBiMap.create();
    @NotNull
    private static final Map<Class<?>, Class<?>> blockClassToBuildingClassMap = new HashMap();
    @NotNull
    private static final Map<Integer, Class<?>> classNameHashToViewClassMap = new HashMap();

    private BuildingRegistry() {
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractBuilding> buildingClass, @NotNull Class<? extends AbstractBuildingView> viewClass, @NotNull Class<? extends AbstractBlockHut> parentBlock) {
        int buildingHashCode = buildingClass.getName().hashCode();
        if (nameToClassMap.containsKey((Object)name) || classNameHashToViewClassMap.containsKey(buildingHashCode)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding AbstractBuilding class mapping");
        }
        try {
            if (buildingClass.getDeclaredConstructor(Colony.class, BlockPos.class) != null) {
                nameToClassMap.put((Object)name, buildingClass);
                classNameHashToViewClassMap.put(buildingHashCode, viewClass);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding AbstractBuilding class mapping", exception);
        }
        if (blockClassToBuildingClassMap.containsKey(parentBlock)) {
            throw new IllegalArgumentException("AbstractBuilding type '" + name + "' uses TileEntity '" + parentBlock.getClass().getName() + "' which is already in use.");
        }
        blockClassToBuildingClassMap.put(parentBlock, buildingClass);
    }

    @Nullable
    public static AbstractBuilding createFromNBT(Colony colony, @NotNull NBTTagCompound compound) {
        AbstractBuilding building = null;
        Class oclass = null;
        try {
            oclass = (Class)nameToClassMap.get((Object)compound.func_74779_i("type"));
            if (oclass != null) {
                BlockPos pos = BlockPosUtil.readFromNBT(compound, "location");
                Constructor constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
                building = (AbstractBuilding)constructor.newInstance(colony, pos);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error((Object)exception);
        }
        if (building == null) {
            Log.getLogger().warn(String.format("Unknown Building type '%s' or missing constructor of proper format.", compound.func_74779_i("type")));
            return null;
        }
        try {
            building.readFromNBT(compound);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A Building %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i("type"), oclass.getName()), (Throwable)ex);
            building = null;
        }
        return building;
    }

    @Nullable
    public static AbstractBuilding create(Colony colony, @NotNull TileEntityColonyBuilding parent) {
        AbstractBuilding building = null;
        try {
            Class<?> oclass = blockClassToBuildingClassMap.get(parent.func_145838_q().getClass());
            if (oclass == null) {
                Log.getLogger().error(String.format("TileEntity %s does not have an associated Building.", ((Object)((Object)parent)).getClass().getName()));
                return null;
            }
            BlockPos loc = parent.getPosition();
            Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
            building = (AbstractBuilding)constructor.newInstance(colony, loc);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error(String.format("Unknown Building type '%s' or missing constructor of proper format.", ((Object)((Object)parent)).getClass().getName()), (Throwable)exception);
        }
        if (building != null && parent.func_145831_w() != null && !(building instanceof PostBox)) {
            WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
            Structure wrapper = new Structure(parent.func_145831_w(), workOrder.getStructureName(), new PlacementSettings());
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getLocation(), parent.func_145831_w(), wrapper, workOrder.getRotation(parent.func_145831_w()), workOrder.isMirrored());
            building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
            building.setHeight(wrapper.getHeight());
            ConstructionTapeHelper.placeConstructionTape(building.getLocation(), corners, parent.func_145831_w());
        }
        return building;
    }

    @Nullable
    public static AbstractBuildingView createBuildingView(ColonyView colony, BlockPos id, @NotNull ByteBuf buf) {
        AbstractBuildingView view = null;
        Class<?> oclass = null;
        try {
            int typeHash = buf.readInt();
            oclass = classNameHashToViewClassMap.get(typeHash);
            if (oclass != null) {
                Constructor<?> constructor = oclass.getDeclaredConstructor(ColonyView.class, BlockPos.class);
                view = (AbstractBuildingView)constructor.newInstance(colony, id);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error((Object)exception);
        }
        if (view == null) {
            Log.getLogger().warn("Unknown AbstractBuilding type, missing View subclass, or missing constructor of proper format.");
            return null;
        }
        try {
            view.deserialize(buf);
        }
        catch (IndexOutOfBoundsException ex) {
            Log.getLogger().error(String.format("A AbstractBuilding View (%s) has thrown an exception during deserializing, its state cannot be restored. Report this to the mod author", oclass.getName()), (Throwable)ex);
            return null;
        }
        return view;
    }

    @NotNull
    public static BiMap<String, Class<?>> getNameToClassMap() {
        return nameToClassMap;
    }

    @NotNull
    public static Map<Class<?>, Class<?>> getBlockClassToBuildingClassMap() {
        return blockClassToBuildingClassMap;
    }

    @NotNull
    public static Map<Integer, Class<?>> getClassNameHashToViewClassMap() {
        return classNameHashToViewClassMap;
    }

    static {
        BuildingRegistry.addMapping("Baker", BuildingBaker.class, BuildingBaker.View.class, BlockHutBaker.class);
        BuildingRegistry.addMapping("Builder", BuildingBuilder.class, BuildingBuilder.View.class, BlockHutBuilder.class);
        BuildingRegistry.addMapping("Home", BuildingHome.class, BuildingHome.View.class, BlockHutCitizen.class);
        BuildingRegistry.addMapping("Farmer", BuildingFarmer.class, BuildingFarmer.View.class, BlockHutFarmer.class);
        BuildingRegistry.addMapping("Lumberjack", BuildingLumberjack.class, BuildingLumberjack.View.class, BlockHutLumberjack.class);
        BuildingRegistry.addMapping("Miner", BuildingMiner.class, BuildingMiner.View.class, BlockHutMiner.class);
        BuildingRegistry.addMapping("TownHall", BuildingTownHall.class, BuildingTownHall.View.class, BlockHutTownHall.class);
        BuildingRegistry.addMapping("Deliveryman", BuildingDeliveryman.class, BuildingDeliveryman.View.class, BlockHutDeliveryman.class);
        BuildingRegistry.addMapping("Fisherman", BuildingFisherman.class, BuildingFisherman.View.class, BlockHutFisherman.class);
        BuildingRegistry.addMapping("GuardTower", BuildingGuardTower.class, BuildingGuardTower.View.class, BlockHutGuardTower.class);
        BuildingRegistry.addMapping("WareHouse", BuildingWareHouse.class, BuildingWareHouse.View.class, BlockHutWareHouse.class);
        BuildingRegistry.addMapping("Cook", BuildingCook.class, BuildingCook.View.class, BlockHutCook.class);
        BuildingRegistry.addMapping("Barracks", BuildingBarracks.class, BuildingBarracks.View.class, BlockHutBarracks.class);
        BuildingRegistry.addMapping("BarracksTower", BuildingBarracksTower.class, BuildingBarracksTower.View.class, BlockHutBarracksTower.class);
        BuildingRegistry.addMapping("Shepherd", BuildingShepherd.class, BuildingShepherd.View.class, BlockHutShepherd.class);
        BuildingRegistry.addMapping("Cowboy", BuildingCowboy.class, BuildingCowboy.View.class, BlockHutCowboy.class);
        BuildingRegistry.addMapping("SwingHerder", BuildingSwineHerder.class, BuildingSwineHerder.View.class, BlockHutSwineHerder.class);
        BuildingRegistry.addMapping("ChickenHerder", BuildingChickenHerder.class, BuildingChickenHerder.View.class, BlockHutChickenHerder.class);
        BuildingRegistry.addMapping("Smeltery", BuildingSmeltery.class, BuildingSmeltery.View.class, BlockHutSmeltery.class);
        BuildingRegistry.addMapping("Composter", BuildingComposter.class, BuildingComposter.View.class, BlockHutComposter.class);
        BuildingRegistry.addMapping("Library", BuildingLibrary.class, BuildingLibrary.View.class, BlockHutLibrary.class);
        BuildingRegistry.addMapping("Archery", BuildingArchery.class, BuildingArchery.View.class, BlockHutArchery.class);
        BuildingRegistry.addMapping("CombatAcademy", BuildingCombatAcademy.class, BuildingCombatAcademy.View.class, BlockHutCombatAcademy.class);
        BuildingRegistry.addMapping("Sawmill", BuildingSawmill.class, BuildingSawmill.View.class, BlockHutSawmill.class);
        BuildingRegistry.addMapping("Blacksmith", BuildingBlacksmith.class, BuildingBlacksmith.View.class, BlockHutBlacksmith.class);
        BuildingRegistry.addMapping("Stonemason", BuildingStonemason.class, BuildingStonemason.View.class, BlockHutStonemason.class);
        BuildingRegistry.addMapping("Postbox", PostBox.class, PostBox.View.class, BlockPostBox.class);
        BuildingRegistry.addMapping("StoneSmeltery", BuildingStoneSmeltery.class, BuildingStoneSmeltery.View.class, BlockHutStoneSmeltery.class);
        BuildingRegistry.addMapping("Crusher", BuildingCrusher.class, BuildingCrusher.View.class, BlockHutCrusher.class);
    }
}

