/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilterableListBuilding
extends AbstractBuildingWorker {
    private static final String TAG_ITEMLIST = "itemList";
    private final List<ItemStorage> itemsAllowed = new ArrayList<ItemStorage>();

    public AbstractFilterableListBuilding(@NotNull Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList itemsToCompost = new NBTTagList();
        for (ItemStorage entry : this.itemsAllowed) {
            NBTTagCompound itemCompound = new NBTTagCompound();
            entry.getItemStack().func_77955_b(itemCompound);
            itemsToCompost.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a(TAG_ITEMLIST, (NBTBase)itemsToCompost);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList itemsToCompost = compound.func_150295_c(TAG_ITEMLIST, 10);
        for (int i = 0; i < itemsToCompost.func_74745_c(); ++i) {
            try {
                this.itemsAllowed.add(new ItemStorage(new ItemStack(itemsToCompost.func_150305_b(i))));
                continue;
            }
            catch (Exception e) {
                Log.getLogger().info("Removing incompatible stack");
            }
        }
    }

    public void addItem(ItemStorage item) {
        if (!this.itemsAllowed.contains(item)) {
            this.itemsAllowed.add(item);
        }
    }

    public boolean isAllowedItem(ItemStorage item) {
        return this.itemsAllowed.contains(item);
    }

    public void removeItem(ItemStorage item) {
        this.itemsAllowed.remove(item);
    }

    public List<ItemStorage> getCopyOfAllowedItems() {
        return new ArrayList<ItemStorage>(this.itemsAllowed);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.itemsAllowed.size());
        for (ItemStorage item : this.itemsAllowed) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)item.getItemStack());
        }
    }
}

