/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingFurnaceUser
extends AbstractFilterableListBuilding {
    private static final String TAG_POS = "pos";
    private static final String TAG_FURNACES = "furnaces";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();

    public AbstractBuildingFurnaceUser(Colony c, BlockPos l) {
        super(c, l);
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList furnacesTagList = new NBTTagList();
        for (BlockPos entry : this.furnaces) {
            NBTTagCompound furnaceCompound = new NBTTagCompound();
            furnaceCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.func_74742_a((NBTBase)furnaceCompound);
        }
        compound.func_74782_a(TAG_FURNACES, (NBTBase)furnacesTagList);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            this.furnaces.add(NBTUtil.func_186861_c((NBTTagCompound)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof BlockFurnace && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
        this.markDirty();
    }

    public List<ItemStack> getAllowedFuel() {
        return this.getCopyOfAllowedItems().stream().map(ItemStorage::getItemStack).peek(stack -> stack.func_190920_e(stack.func_77976_d())).collect(Collectors.toList());
    }
}

