/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.views.FilterableListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.NotNull;

public abstract class WindowFilterableList<B extends FilterableListView>
extends AbstractWindowWorkerBuilding<B> {
    private static final String VIEW_PAGES = "pages";
    private static final String WINDOW_FILTERABLE_LIST = ":gui/windowfilterablelist.xml";
    private static final String INPUT_NAME = "input";
    public static final String DESC_LABEL = "desc";
    private static final String BUTTON_SWITCH = "switch";
    private static final String ON = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]);
    private static final String OFF = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOff", new Object[0]);
    private static final String BUTTON_PREV_PAGE = "prevPage";
    private static final String BUTTON_NEXT_PAGE = "nextPage";
    private Button buttonPrevPage;
    private Button buttonNextPage;
    private final List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
    protected final FilterableListView building;
    private String filter = "";
    protected boolean isInverted = false;
    private Predicate<ItemStack> itemStackPredicate;

    public WindowFilterableList(B building, Predicate<ItemStack> predicate, String desc) {
        super(building, "minecolonies:gui/windowfilterablelist.xml");
        this.itemStackPredicate = predicate;
        this.findPaneOfTypeByID(DESC_LABEL, Label.class).setLabelText(desc);
        this.building = building;
        this.registerButton(BUTTON_PREV_PAGE, this::prevClicked);
        this.registerButton(BUTTON_NEXT_PAGE, this::nextClicked);
        this.registerButton(BUTTON_SWITCH, this::switchClicked);
    }

    private void switchClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (button.getLabel().equals(ON)) {
            button.setLabel(OFF);
            if (this.isInverted) {
                this.building.addItem(this.allItems.get(row));
            } else {
                this.building.removeItem(this.allItems.get(row));
            }
        } else {
            button.setLabel(ON);
            if (this.isInverted) {
                this.building.removeItem(this.allItems.get(row));
            } else {
                this.building.addItem(this.allItems.get(row));
            }
        }
        this.resourceList.refreshElementPanes();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class).setEnabled(false);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXT_PAGE, Button.class);
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_82833_r().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.allItems.addAll(this.getExceptions().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList()));
        this.updateResourceList();
    }

    public Collection<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate) {
        return ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
            NonNullList stacks = NonNullList.func_191196_a();
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            }
            catch (Exception ex) {
                Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName(), (Throwable)ex);
            }
            return stacks.stream().filter(this.itemStackPredicate.and(filterPredicate)).map(ItemStorage::new);
        }).collect(Collectors.toList()));
    }

    public List<ItemStorage> getExceptions() {
        return Collections.emptyList();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        this.filter = this.findPaneOfTypeByID(INPUT_NAME, TextField.class).getText();
        this.updateResources();
        return result;
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.allItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ItemStorage)tempRes.get(index)).getItemStack();
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_82833_r());
                resourceLabel.setColor(7, 7);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(resource);
                Button switchButton = rowPane.findPaneOfTypeByID(WindowFilterableList.BUTTON_SWITCH, Button.class);
                if (WindowFilterableList.this.isInverted && !WindowFilterableList.this.building.isAllowedItem(new ItemStorage(resource)) || !WindowFilterableList.this.isInverted && WindowFilterableList.this.building.isAllowedItem(new ItemStorage(resource))) {
                    switchButton.setLabel(ON);
                } else {
                    switchButton.setLabel(OFF);
                }
            }
        });
    }

    private void prevClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
        this.buttonPrevPage.setEnabled(false);
        this.buttonNextPage.setEnabled(true);
    }

    private void nextClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
        this.buttonPrevPage.setEnabled(true);
        this.buttonNextPage.setEnabled(false);
    }
}

