/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.configuration;

import net.minecraftforge.common.config.Config;

@Config(modid="minecolonies")
public class Configurations {
    @Config.Comment(value={"All configuration related to gameplay"})
    public static Gameplay gameplay = new Gameplay();
    @Config.Comment(value={"All configuration related to mod compatibility"})
    public static Compatibility compatibility = new Compatibility();
    @Config.Comment(value={"All configurations related to pathfinding"})
    public static Pathfinding pathfinding = new Pathfinding();
    @Config.Comment(value={"All configurations related to the request system"})
    public static RequestSystem requestSystem = new RequestSystem();

    public static class RequestSystem {
        @Config.Comment(value={"Should the request system print out debug information? Useful in case of malfunctioning of set system."})
        public boolean enableDebugLogging = false;
        @Config.Comment(value={"The maximal amount of tries that the request system will perform for retryable requests. Higher increases server load."})
        public int maximalRetries = 3;
        @Config.Comment(value={"The amount of ticks between retries of the request system for retryable requests. Lower increases server load."})
        public int delayBetweenRetries = 1200;
        @Config.Comment(value={"The maximal amount of buildings the Delivery Man should try to gather before attempting a drop off at the warehouse."})
        public int maximalBuildingsToGather = 6;
        @Config.Comment(value={"The minimal amount of buildings the Delivery Man should try to gather before attempting a drop off at the warehouse."})
        public int minimalBuildingsToGather = 3;
        @Config.Comment(value={"Should the request system creatively resolve (if possible) when the player is required to resolve a request."})
        public boolean creativeResolve = false;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony rs reset' command?"})
        public boolean canPlayerUseResetCommand = false;
    }

    public static class Pathfinding {
        @Config.Comment(value={"Draw pathfinding paths (might be laggy)"})
        public boolean pathfindingDebugDraw = false;
        @Config.Comment(value={"Verbosity of pathfinding"})
        public int pathfindingDebugVerbosity = 0;
        @Config.Comment(value={"Amount of additional threads to be used for pathfinding"})
        public int pathfindingMaxThreadCount = 2;
        @Config.Comment(value={"Max amount of Nodes(positions) to map during pathfinding. Default 5000: Lowering increases performance, but might lead to pathing glitches"})
        public int pathfindingMaxNodes = 5000;
    }

    public static class Compatibility {
        @Config.Comment(value={"Harvest trunk-size for dynamic trees:1-8, default:5"})
        public int dynamicTreeHarvestSize = 5;
    }

    public static class Gameplay {
        @Config.Comment(value={"Should builder place construction tape?"})
        public boolean builderPlaceConstructionTape = true;
        @Config.Comment(value={"Colony size (radius) - deprecated, don't use"})
        public int workingRangeTownHall = 200;
        @Config.Comment(value={"Colony size (radius in chunks around central colony chunk). Changing this affects only newly placed colonies, for old ones use the /mc colony claim command"})
        public int workingRangeTownHallChunks = 8;
        @Config.Comment(value={"Padding between colonies  - deprecated, don't use"})
        public int townHallPadding = 20;
        @Config.Comment(value={"Padding between colonies in chunks"})
        public int townHallPaddingChunk = 1;
        @Config.Comment(value={"Should player get one guidebook on first join to a new world?"})
        public boolean playerGetsGuidebookOnFirstJoin = true;
        @Config.Comment(value={"Should supply chests be craftable on this server?"})
        public boolean supplyChests = true;
        @Config.Comment(value={"Should players be able to place an infinite amount of supplychests?"})
        public boolean allowInfiniteSupplyChests = false;
        @Config.Comment(value={"Should players be allowed to abandon their colony to create a new one easily?"})
        public boolean allowInfiniteColonies = false;
        @Config.RangeInt(min=10, max=600)
        @Config.Comment(value={"Average citizen respawn interval (in seconds)"})
        public int citizenRespawnInterval = 60;
        @Config.Comment(value={"Max citizens in one colony"})
        public int maxCitizenPerColony = 50;
        @Config.Comment(value={"Should builder and miner build without resources? (this also turns off what they produce)"})
        public boolean builderInfiniteResources = false;
        @Config.Comment(value={"Should there be at max 1 warehouse per colony?"})
        public boolean limitToOneWareHousePerColony = true;
        @Config.Comment(value={"Delay after each block placement (Increasing it, increases the delay)"})
        public int builderBuildBlockDelay = 15;
        @Config.Comment(value={"Delay modifier to mine a block (Decreasing it, decreases the delay)"})
        public int blockMiningDelayModifier = 500;
        @Config.Comment(value={"Ores for the miner to mine that aren't autodetected"})
        public String[] extraOres = new String[]{"minestuck:ore_cruxite", "minestuck:ore_uranium"};
        @Config.Comment(value={"Should workers work during the rain?"})
        public boolean workersAlwaysWorkInRain = false;
        @Config.Comment(value={"Should the colony protection be enabled?"})
        public boolean enableColonyProtection = true;
        @Config.Comment(value={"Should Players be sent entering/leaving colony notifications?"})
        public boolean sendEnteringLeavingMessages = true;
        @Config.Comment(value={"Independent from the colony protection, should explosions be turned off?"})
        public boolean turnOffExplosionsInColonies = true;
        @Config.Comment(value={"Whether or not to spawn barbarians"})
        public boolean doBarbariansSpawn = true;
        @Config.RangeInt(min=0, max=10)
        @Config.Comment(value={"The difficulty setting for barbarians"})
        public int barbarianHordeDifficulty = 5;
        @Config.RangeInt(min=1, max=10)
        @Config.Comment(value={"The spawn size of a barbarian horde"})
        public int spawnBarbarianSize = 5;
        @Config.RangeInt(min=6, max=40)
        @Config.Comment(value={"The max size of a barbarian horde"})
        public int maxBarbarianSize = 20;
        @Config.Comment(value={"Whether or not to barbarians can break, scale, bridge obstacles"})
        public boolean doBarbariansBreakThroughWalls = true;
        @Config.Comment(value={"The average amount of nights between raids"})
        public int averageNumberOfNightsBetweenRaids = 3;
        @Config.Comment(value={"The minimum number of nights between raids"})
        public int minimumNumberOfNightsBetweenRaids = 1;
        @Config.Comment(value={"Should players be allowed to build their colonies over existing villages?"})
        public boolean protectVillages = false;
        @Config.Comment(value={"Should player made schematics be allowed"})
        public boolean allowPlayerSchematics = false;
        @Config.Comment(value={"Should players be allowed to change names? -1 for false, 0 for specific groups, 1 for true"})
        public int allowGlobalNameChanges = 1;
        @Config.Comment(value={"Players who have special permission (Patreons for example)"})
        public String[] specialPermGroup = new String[]{"_Raycoms_"};
        @Config.Comment(value={"Time until a next teleport can be executed (in seconds)"})
        public int teleportBuffer = 120;
        @Config.Comment(value={"Which level counts as op level on the server"})
        public int opLevelForServer = 3;
        @Config.Comment(value={"Sets the amount of hours until a colony will be deleted after not seeing it's mayor, set to zero to disable"})
        public int autoDeleteColoniesInHours = 0;
        @Config.Comment(value={"Sets weither or not Colony structures are destroyed automatically."})
        public boolean autoDestroyColonyBlocks = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc rtp' command?"})
        public boolean canPlayerUseRTPCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony teleport' command?"})
        public boolean canPlayerUseColonyTPCommand = false;
        @Config.Comment(value={"Should the player be allowed to use the '/mc home' command?"})
        public boolean canPlayerUseHomeTPCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens info' command?"})
        public boolean canPlayerUseCitizenInfoCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens list' command?"})
        public boolean canPlayerUseListCitizensCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens respawn' command?"})
        public boolean canPlayerRespawnCitizensCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony info' command?"})
        public boolean canPlayerUseShowColonyInfoCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens kill' command?"})
        public boolean canPlayerUseKillCitizensCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony addOfficer' command?"})
        public boolean canPlayerUseAddOfficerCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony delete' command?"})
        public boolean canPlayerUseDeleteColonyCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony refresh' command?"})
        public boolean canPlayerUseRefreshColonyCommand = false;
        @Config.Comment(value={"Should the player be allowed to use the '/mc backup' command?"})
        public boolean canPlayerUseBackupCommand = false;
        @Config.Comment(value={"Amount of attempts to find a save rtp"})
        public int numberOfAttemptsForSafeTP = 4;
        @Config.Comment(value={"Should the min/max distance from spawn also affect colony placement?"})
        public boolean restrictColonyPlacement = false;
        @Config.Comment(value={"Max distance from world spawn"})
        public int maxDistanceFromWorldSpawn = 8000;
        @Config.Comment(value={"Min distance from world spawn"})
        public int minDistanceFromWorldSpawn = 512;
        @Config.Comment(value={"Amount of initial citizens"})
        public int initialCitizenAmount = 4;
        @Config.Comment(value={"Should citizen name tags be rendered?"})
        public boolean alwaysRenderNameTag = true;
        @Config.Comment(value={"Child growth modifier, default on avg they take about 60min to grow (at 1.0x modifier). Setting to 5 = 5x as fast. Default value: 1"})
        public double growthModifier = 1.0;
        @Config.Comment(value={"Should Guard Rangers benefit from Power/Smite/Bane of Arthropods enchants?"})
        public boolean rangerEnchants = true;
        @Config.Comment(value={"Damage multiplier for Ranger Guards: Default:1.0"})
        public double rangerDamageMult = 1.0;
        @Config.Comment(value={"Damage multiplier for Knight Guards: Default:1.0"})
        public double knightDamageMult = 1.0;
        @Config.Comment(value={"Health multiplier for all Guards: Default:1.0"})
        public double guardHealthMult = 1.0;
        @Config.Comment(value={"Amount of blocks the builder checks (to decrease lag by builder)"})
        public int maxBlocksCheckedByBuilder = 1000;
        @Config.Comment(value={"Chat frequency of worker requests"})
        public int chatFrequency = 30;
        @Config.Comment(value={"Should in development features be enabled (might be buggy)"})
        public boolean enableInDevelopmentFeatures = false;
        @Config.Comment(value={"Blocks players should be able to interact with in any colony (Ex vending machines)"})
        public String[] freeToInteractBlocks = new String[]{"block:dirt", "0 0 0"};
        @Config.Comment(value={"Should colonies in other dimensions be allowed (Default = false)?"})
        public boolean allowOtherDimColonies = false;
        @Config.Comment(value={"ResourceLocations for extra entities for the GuardHut's list. \nonce done you'll need to recalculate the list.EntityMob's already calculated in list."})
        public String[] guardResourceLocations = new String[]{"minecraft:slime", "tconstruct:blueslime"};
        @Config.Comment(value={"List of items the Students in the library can use. \nFormat: itemname;SkillIncreasePCT[100-1000];BreakPCT[0-100] \nExample: minecraft:paper;300;100 \nWhich adds minecraft Paper with a 400%(4x) increased chance to skillup and a 100% chance to be used up during the try to skillup"})
        public final String[] configListStudyItems = new String[]{"minecraft:paper;400;100"};
        @Config.Comment(value={"The items and item-tags that the composter can use to produce compost."})
        public String[] listOfCompostableItems = new String[]{"minecraft:rotten_flesh", "minecraft:tallgrass", "minecraft:yellow_flower", "minecraft:red_flower", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:double_plant", "food", "seed", "treeSapling"};
        @Config.Comment(value={"Turn on Minecolonies pvp mode, attention (colonies can be destroyed and can be griefed under certain conditions.)"})
        public boolean pvp_mode = false;
        @Config.Comment(value={"Days until the pirate ships despawn again."})
        public int daysUntilPirateshipsDespawn = 3;
        @Config.Comment(value={"Should special holiday content be displayed?"})
        public boolean holidayFeatures = true;
        @Config.Comment(value={"AI Update rate, increase to improve performance. Default: 1"})
        public int updateRate = 1;
        @Config.Comment(value={"Quantity of dirt per Compost filling. Default: 1"})
        public int dirtFromCompost = 1;
        @Config.Comment(value={"Chance to get a lucky block in percent. Default: 1"})
        public int luckyBlockChance = 1;
        @Config.Comment(value={"The blocks where the miner has a chance to get a random ore."})
        public String[] luckyBlocks = new String[]{"minecraft:stone", "minecraft:cobblestone"};
        @Config.Comment(value={"The random ores the miner can get separated by ! for rarity"})
        public String[] luckyOres = new String[]{"minecraft:coal_ore!64", "minecraft:iron_ore!32", "minecraft:gold_ore!16", "minecraft:redstone_ore!8", "minecraft:lapis_ore!4", "minecraft:diamond_ore!2", "minecraft:emerald_ore!1"};
        @Config.Comment(value={"Automatically fix orphaned chunks which were caused by chunk loading and saving issues"})
        public boolean fixOrphanedChunks = false;
    }
}

