/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.teleporter;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import thebetweenlands.common.world.teleporter.TeleporterBetweenlands;

public final class TeleporterHandler {
    private static final TeleporterHandler INSTANCE = new TeleporterHandler();

    private TeleporterHandler() {
    }

    public static void transferToDim(Entity entity, World world) {
        INSTANCE.transferEntity(entity, world.field_73011_w.getDimension(), true, true);
    }

    public static void transferToDim(Entity entity, World world, boolean makePortal, boolean setSpawn) {
        INSTANCE.transferEntity(entity, world.field_73011_w.getDimension(), makePortal, setSpawn);
    }

    private void transferEntity(Entity entity, int dimensionId, boolean makePortal, boolean setSpawn) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !entity.field_70128_L && !(entity instanceof FakePlayer) && world instanceof WorldServer) {
            if (!ForgeHooks.onTravelToDimension((Entity)entity, (int)dimensionId)) {
                return;
            }
            MinecraftServer server = world.func_73046_m();
            WorldServer toWorld = server.func_71218_a(dimensionId);
            AxisAlignedBB aabb = entity.func_174813_aQ();
            aabb = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.field_184851_cj = true;
                player.field_71133_b.func_184103_al().transferPlayerToDimension(player, dimensionId, (Teleporter)new TeleporterBetweenlands(world.field_73011_w.getDimension(), aabb, toWorld, makePortal, setSpawn));
                player.field_71088_bW = 0;
            } else {
                entity.func_184174_b(false);
                world.func_72973_f(entity);
                entity.field_71093_bK = dimensionId;
                entity.field_70128_L = false;
                WorldServer oldWorld = server.func_71218_a(entity.field_71093_bK);
                server.func_184103_al().transferEntityToWorld(entity, dimensionId, oldWorld, toWorld, (Teleporter)new TeleporterBetweenlands(world.field_73011_w.getDimension(), aabb, toWorld, makePortal, setSpawn));
            }
        }
    }
}

