/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.teleporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.layer.IntCache;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.config.properties.StringSetProperty;
import thebetweenlands.common.handler.PlayerRespawnHandler;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSmallPortal;
import thebetweenlands.common.world.gen.feature.structure.WorldGenWeedwoodPortalTree;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationPortal;

public final class TeleporterBetweenlands
extends Teleporter {
    private final WorldServer toWorld;
    private final int fromDim;
    private final AxisAlignedBB fromBounds;
    private final boolean makePortal;
    private final boolean setSpawn;
    private final boolean isToEnd;
    public static final String LAST_PORTAL_POS_NBT = "thebetweenlands.last_portal_location";

    public TeleporterBetweenlands(int fromDim, AxisAlignedBB fromBounds, WorldServer toWorld, boolean makePortal, boolean setSpawn) {
        super(toWorld);
        this.fromBounds = fromBounds;
        this.fromDim = fromDim;
        this.toWorld = toWorld;
        this.makePortal = makePortal;
        this.setSpawn = setSpawn;
        this.isToEnd = this.toWorld.field_73011_w.func_186058_p().func_186068_a() == 1;
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        if (!this.isToEnd || BetweenlandsConfig.WORLD_AND_DIMENSION.generatePortalInEnd) {
            if (!this.func_180620_b(entity, rotationYaw)) {
                if (this.isToEnd) {
                    this.moveToWorldSpawn(entity);
                    entity.func_70012_b(entity.field_70165_t + (double)this.field_85192_a.field_73012_v.nextInt(32) - 16.0, entity.field_70163_u, entity.field_70161_v + (double)this.field_85192_a.field_73012_v.nextInt(32) - 16.0, entity.field_70177_z, entity.field_70125_A);
                }
                if (!this.func_85188_a(entity) && this.setSpawn) {
                    if (!this.makePortal) {
                        BlockPos pos = this.findSuitableBetweenlandsPortalPos(entity.func_180425_c());
                        pos = PlayerRespawnHandler.getRespawnPointNearPos((World)this.toWorld, pos, 64);
                        pos = this.setDefaultPlayerSpawnLocation(pos, entity);
                        this.setEntityLocation(entity, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
                    } else {
                        int zo;
                        int xo;
                        BlockPos pos = this.findSuitableBetweenlandsPortalPos(entity.func_180425_c());
                        Chunk chunk = this.getDecoratedChunk((World)this.toWorld, pos);
                        pos = new BlockPos(pos.func_177958_n(), chunk.func_177433_f(pos), pos.func_177952_p());
                        for (xo = -1; xo <= 1; ++xo) {
                            for (zo = -1; zo <= 1; ++zo) {
                                for (int yo = 0; yo <= 2; ++yo) {
                                    this.toWorld.func_175698_g(pos.func_177982_a(xo, yo, zo));
                                }
                            }
                        }
                        for (xo = -1; xo <= 1; ++xo) {
                            for (zo = -1; zo <= 1; ++zo) {
                                this.toWorld.func_175656_a(pos.func_177982_a(xo, -1, zo), BlockRegistry.LOG_PORTAL.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
                            }
                        }
                        this.setEntityLocation(entity, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rotationYaw, 0.0f);
                        this.setDefaultPlayerSpawnLocation(pos, entity);
                    }
                }
            }
        } else {
            this.moveToWorldSpawn(entity);
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
            int z = MathHelper.func_76128_c((double)entity.field_70161_v);
            this.generateEndPlatform(x, y, z, true);
            entity.func_70012_b((double)x, (double)y, (double)z, entity.field_70177_z, 0.0f);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
        }
    }

    private boolean moveToWorldSpawn(Entity entity) {
        BlockPos spawn = this.toWorld.func_180504_m();
        if (spawn != null) {
            entity.func_174828_a(spawn, entity.field_70177_z, entity.field_70125_A);
            return true;
        }
        return false;
    }

    private void generateEndPlatform(int x, int y, int z, boolean setAir) {
        for (int zo = -2; zo <= 2; ++zo) {
            for (int xo = -2; xo <= 2; ++xo) {
                for (int yo = -1; yo < (setAir ? 3 : 0); ++yo) {
                    int bx = x + xo;
                    int by = y + yo;
                    int bz = z + zo;
                    boolean air = yo < 0;
                    this.field_85192_a.func_175656_a(new BlockPos(bx, by, bz), air ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        BlockPos existingPortal;
        if (this.setSpawn && (existingPortal = this.findExistingPortalPos()) != null) {
            this.setEntityLocation(entity, (double)existingPortal.func_177958_n() + 0.5, (double)existingPortal.func_177956_o() + 2.0, (double)existingPortal.func_177952_p() + 0.5, rotationYaw, 0.0f);
            this.setDefaultPlayerSpawnLocation(existingPortal, entity);
            return true;
        }
        return false;
    }

    @Nullable
    protected BlockPos findExistingPortalPos() {
        LocationPortal otherPortal;
        LocationPortal portal = this.getPortalLocation();
        if (portal != null && (otherPortal = this.getOtherPortalLocation(portal.getOtherPortalPosition())) != null) {
            return otherPortal.getPortalPosition();
        }
        return null;
    }

    @Nullable
    protected LocationPortal getPortalLocation() {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld((World)this.toWorld.func_73046_m().func_71218_a(this.fromDim));
        List<LocationPortal> portals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, this.fromBounds, loc -> loc.intersects(this.fromBounds));
        this.validatePortals(portals);
        if (!portals.isEmpty()) {
            return portals.get(0);
        }
        return null;
    }

    @Nullable
    protected LocationPortal getOtherPortalLocation(@Nullable BlockPos pos) {
        if (pos != null) {
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld((World)this.toWorld);
            List<LocationPortal> otherPortals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, pos.func_177958_n(), pos.func_177952_p(), loc -> loc.getPortalPosition().equals((Object)pos));
            this.validatePortals(otherPortals);
            if (!otherPortals.isEmpty()) {
                return otherPortals.get(0);
            }
        }
        return null;
    }

    protected void validatePortals(List<LocationPortal> portals) {
        Iterator<LocationPortal> it = portals.iterator();
        while (it.hasNext()) {
            LocationPortal portal = it.next();
            if (this.checkPortal(portal)) continue;
            portal.getWorldStorage().getLocalStorageHandler().removeLocalStorage(portal);
            it.remove();
        }
    }

    protected boolean checkPortal(LocationPortal portal) {
        World world = portal.getWorldStorage().getWorld();
        AxisAlignedBB aabb = portal.getBounds().get(0);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = MathHelper.func_76128_c((double)aabb.field_72340_a); x <= MathHelper.func_76128_c((double)aabb.field_72336_d); ++x) {
            for (int y = MathHelper.func_76128_c((double)aabb.field_72338_b); y <= MathHelper.func_76128_c((double)aabb.field_72337_e); ++y) {
                for (int z = MathHelper.func_76128_c((double)aabb.field_72339_c); z <= MathHelper.func_76128_c((double)aabb.field_72334_f); ++z) {
                    pos.func_181079_c(x, y, z);
                    IBlockState blockState = world.func_180495_p((BlockPos)pos);
                    if (!(blockState.func_177230_c() instanceof BlockTreePortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected BlockPos findSuitableBetweenlandsPortalPos(BlockPos start) {
        ArrayList<BiomeBetweenlands> validBiomes = new ArrayList<BiomeBetweenlands>();
        validBiomes.add(BiomeRegistry.SWAMPLANDS);
        validBiomes.add(BiomeRegistry.PATCHY_ISLANDS);
        BlockPos suitablePos = this.toWorld.func_72959_q().func_180630_a(start.func_177958_n(), start.func_177952_p(), BetweenlandsConfig.WORLD_AND_DIMENSION.portalBiomeSearchRange, validBiomes, this.toWorld.field_73012_v);
        BlockPos selectedPos = suitablePos != null ? suitablePos : start;
        Chunk chunk = this.getDecoratedChunk((World)this.toWorld, selectedPos);
        int height = chunk.func_177433_f(selectedPos);
        return new BlockPos(selectedPos.func_177958_n(), height, selectedPos.func_177952_p());
    }

    @Nullable
    protected BlockPos findSuitableNonBLStartPos(BlockPos start) {
        StringSetProperty unsafeBiomes = BetweenlandsConfig.WORLD_AND_DIMENSION.portalUnsafeBiomesSet;
        if (unsafeBiomes.isEmpty()) {
            return start;
        }
        if (!unsafeBiomes.contains(this.toWorld.func_180494_b(start).getRegistryName().toString())) {
            return start;
        }
        int range = BetweenlandsConfig.WORLD_AND_DIMENSION.portalBiomeSearchRange;
        IntCache.func_76446_a();
        int searchStartX = start.func_177958_n() - range >> 2;
        int searchStartZ = start.func_177952_p() - range >> 2;
        int searchEndX = start.func_177958_n() + range >> 2;
        int searchEndZ = start.func_177952_p() + range >> 2;
        int searchWidth = searchEndX - searchStartX + 1;
        int searchDepth = searchEndZ - searchStartZ + 1;
        Biome[] biomes = this.toWorld.func_72959_q().func_76937_a(new Biome[0], searchStartX, searchStartZ, searchWidth, searchDepth);
        BlockPos suitablePos = null;
        int counter = 0;
        for (int i = 0; i < searchWidth * searchDepth; ++i) {
            int bx = searchStartX + i % searchWidth << 2;
            int by = searchStartZ + i / searchWidth << 2;
            Biome biome = biomes[i];
            if (unsafeBiomes.contains(biome.getRegistryName().toString()) || suitablePos != null && this.toWorld.field_73012_v.nextInt(counter + 1) != 0) continue;
            suitablePos = new BlockPos(bx, 0, by);
            ++counter;
        }
        return suitablePos;
    }

    protected BlockPos findSuitableNonBLPortalPos(BlockPos start) {
        int randY;
        int yo;
        BlockPos suitableStartPos = this.findSuitableNonBLStartPos(start);
        if (suitableStartPos != null) {
            start = suitableStartPos;
        }
        int bestYSpace = -1;
        BlockPos bestSuitablePos = null;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int xo = -16; xo <= -16; ++xo) {
            for (int zo = -16; zo <= -16; ++zo) {
                checkPos.func_181079_c(start.func_177958_n() + xo, start.func_177956_o(), start.func_177952_p() + zo);
                Chunk chunk = this.getDecoratedChunk((World)this.toWorld, (BlockPos)checkPos);
                int height = chunk.func_177433_f((BlockPos)checkPos);
                if (height > 0 && height < this.toWorld.func_72940_L() - 16) {
                    return new BlockPos(checkPos.func_177958_n(), height, checkPos.func_177952_p());
                }
                int ySpace = -1;
                boolean isUnsuitable = true;
                for (int y = this.toWorld.func_72940_L() - 16 + 1; y > 8; --y) {
                    boolean isNextUnsuitable;
                    checkPos.func_185336_p(y);
                    IBlockState state = chunk.func_177435_g((BlockPos)checkPos);
                    boolean isNextLiquid = state.func_185904_a().func_76224_d();
                    boolean bl = isNextUnsuitable = state.func_185915_l() || isNextLiquid;
                    if (!isUnsuitable) {
                        if (isNextUnsuitable) {
                            if (ySpace >= bestYSpace && !isNextLiquid) {
                                bestYSpace = ySpace;
                                bestSuitablePos = new BlockPos(checkPos.func_177958_n(), y, checkPos.func_177952_p());
                                if (bestYSpace >= 20) {
                                    return bestSuitablePos;
                                }
                            }
                            ySpace = 0;
                        } else {
                            ++ySpace;
                        }
                    }
                    isUnsuitable = isNextUnsuitable;
                }
            }
        }
        if (bestSuitablePos != null) {
            return bestSuitablePos;
        }
        if (this.isToEnd) {
            return start;
        }
        block3: for (randY = 8 + this.toWorld.field_73012_v.nextInt(this.toWorld.func_72940_L() - 16 - 8); randY < this.toWorld.func_72940_L() - 28; randY += yo + 1) {
            int height;
            for (yo = height = 5; yo > 0; --yo) {
                for (int xo = -4; xo <= 4; ++xo) {
                    for (int zo = -4; zo <= 4; ++zo) {
                        checkPos.func_181079_c(start.func_177958_n() + xo, randY + yo, start.func_177952_p() + zo);
                        if (!this.toWorld.func_180495_p((BlockPos)checkPos).func_185904_a().func_76224_d()) continue;
                        continue block3;
                    }
                }
            }
        }
        return new BlockPos(start.func_177958_n(), randY, start.func_177952_p());
    }

    public boolean func_85188_a(Entity entity) {
        if (this.makePortal) {
            boolean isToBL = this.toWorld.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId;
            BlockPos center = isToBL ? this.findSuitableBetweenlandsPortalPos(entity.func_180425_c()) : this.findSuitableNonBLPortalPos(entity.func_180425_c());
            if (isToBL && this.generateBetweenlandsTreePortal(entity, center)) {
                return true;
            }
            if (!isToBL && this.generateTreePortal(entity, center)) {
                return true;
            }
            return this.generateSmallPortal(entity, center);
        }
        return false;
    }

    protected boolean generateBetweenlandsTreePortal(Entity entity, BlockPos center) {
        WorldGenWeedwoodPortalTree genTree = new WorldGenWeedwoodPortalTree();
        return this.spiralGenerate(center, 64, 0, 0, checkPos -> {
            Chunk chunk = this.getDecoratedChunk((World)this.toWorld, (BlockPos)checkPos);
            checkPos.func_185336_p(chunk.func_177433_f((BlockPos)checkPos) - 1);
            if (SurfaceType.MIXED_GROUND.matches(this.toWorld.func_180495_p((BlockPos)checkPos)) && this.toWorld.func_175623_d(checkPos.func_177984_a()) && this.canGeneratePortalTree((World)this.toWorld, (BlockPos)checkPos) && genTree.func_180709_b((World)this.toWorld, this.toWorld.field_73012_v, checkPos.func_185334_h())) {
                this.lonkPortalsTogetherAndTeleport(entity, (BlockPos)checkPos, 0.5, 2.0, 0.5);
                return true;
            }
            return false;
        });
    }

    protected boolean generateTreePortal(Entity entity, BlockPos center) {
        WorldGenWeedwoodPortalTree genTree = new WorldGenWeedwoodPortalTree();
        return this.spiralGenerate(center, 64, Math.min(center.func_177956_o() - 2, 8), 8, checkPos -> {
            BlockPos pos;
            if (this.toWorld.func_180495_p((BlockPos)checkPos).func_185915_l() && this.toWorld.func_175623_d(checkPos.func_177984_a()) && this.canGeneratePortalTree((World)this.toWorld, (BlockPos)checkPos) && genTree.func_180709_b((World)this.toWorld, this.toWorld.field_73012_v, pos = checkPos.func_185334_h())) {
                this.lonkPortalsTogetherAndTeleport(entity, pos, 0.5, 2.0, 0.5);
                if (this.isToEnd) {
                    this.generateEndPlatform(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), false);
                }
                return true;
            }
            return false;
        });
    }

    protected boolean generateSmallPortal(Entity entity, BlockPos center) {
        WorldGenSmallPortal genPortal = new WorldGenSmallPortal(EnumFacing.NORTH);
        if (this.spiralGenerate(center, 64, Math.min(center.func_177956_o() - 2, 8), 8, checkPos -> {
            BlockPos pos;
            if (this.toWorld.func_180495_p((BlockPos)checkPos).func_185915_l() && this.toWorld.func_175623_d(checkPos.func_177984_a()) && this.canGenerateSmallPortalInOpen((World)this.toWorld, checkPos.func_177984_a()) && genPortal.func_180709_b((World)this.toWorld, this.toWorld.field_73012_v, pos = checkPos.func_185334_h().func_177984_a())) {
                this.lonkPortalsTogetherAndTeleport(entity, pos, 0.5, 1.0, -0.5);
                if (this.isToEnd) {
                    this.generateEndPlatform(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), false);
                }
                return true;
            }
            return false;
        })) {
            return true;
        }
        if (this.spiralGenerate(center, 32, Math.min(center.func_177956_o() - 2, 8), 8, checkPos -> {
            BlockPos pos;
            if (this.toWorld.func_180495_p((BlockPos)checkPos).func_185915_l() && !this.isSmallPortalObstructedByOthersOrLiquid((World)this.toWorld, (BlockPos)checkPos) && genPortal.func_180709_b((World)this.toWorld, this.toWorld.field_73012_v, pos = checkPos.func_185334_h().func_177984_a())) {
                this.lonkPortalsTogetherAndTeleport(entity, pos, 0.5, 1.0, -0.5);
                if (this.isToEnd) {
                    this.generateEndPlatform(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), false);
                }
                return true;
            }
            return false;
        })) {
            return true;
        }
        if (genPortal.func_180709_b((World)this.toWorld, this.toWorld.field_73012_v, center.func_185334_h())) {
            this.lonkPortalsTogetherAndTeleport(entity, center.func_185334_h(), 0.5, 1.0, -0.5);
            if (this.isToEnd) {
                this.generateEndPlatform(center.func_177958_n(), center.func_177956_o() + 1, center.func_177952_p(), false);
            }
            return true;
        }
        return false;
    }

    protected void lonkPortalsTogetherAndTeleport(Entity entity, BlockPos newPortalPos, double playerOffsetX, double playerOffsetY, double playerOffsetZ) {
        BetweenlandsWorldStorage worldStorage;
        List<LocationPortal> newPortals;
        LocationPortal portal = this.getPortalLocation();
        if (portal != null && !(newPortals = (worldStorage = BetweenlandsWorldStorage.forWorld((World)this.toWorld)).getLocalStorageHandler().getLocalStorages(LocationPortal.class, newPortalPos.func_177958_n(), newPortalPos.func_177952_p(), loc -> loc.isInside((Vec3i)newPortalPos.func_177981_b(2)))).isEmpty()) {
            LocationPortal newPortal = newPortals.get(0);
            newPortal.setOtherPortalPosition(this.fromDim, portal.getPortalPosition());
            portal.setOtherPortalPosition(this.toWorld.field_73011_w.getDimension(), newPortal.getPortalPosition());
        }
        if (this.setSpawn) {
            this.setEntityLocation(entity, (double)newPortalPos.func_177958_n() + playerOffsetX, (double)newPortalPos.func_177956_o() + playerOffsetY, (double)newPortalPos.func_177952_p() + playerOffsetZ, entity.field_70177_z, 0.0f);
            this.setDefaultPlayerSpawnLocation(newPortalPos, entity);
        }
    }

    protected boolean spiralGenerate(BlockPos center, int radius, int yDown, int yUp, Function<BlockPos.MutableBlockPos, Boolean> gen) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int xo = 0;
        int zo = 0;
        int[] dir = new int[]{0, -1};
        for (int i = (int)Math.pow(radius * 2, 2.0); i > 0; --i) {
            if (-radius < xo && xo <= radius && -radius < zo && zo <= radius) {
                checkPos.func_181079_c(center.func_177958_n() + xo, center.func_177956_o(), center.func_177952_p() + zo);
                if (gen.apply(checkPos).booleanValue()) {
                    return true;
                }
                if (yDown != 0 || yUp != 0) {
                    int yo;
                    Chunk chunk = this.getDecoratedChunk((World)this.toWorld, (BlockPos)checkPos);
                    int height = chunk.func_177433_f((BlockPos)checkPos) - 1;
                    for (yo = 1; yo <= yUp; ++yo) {
                        checkPos.func_181079_c(center.func_177958_n() + xo, height + yo, center.func_177952_p() + zo);
                        if (!gen.apply(checkPos).booleanValue()) continue;
                        return true;
                    }
                    for (yo = 1; yo <= yDown; ++yo) {
                        checkPos.func_181079_c(center.func_177958_n() + xo, height - yo, center.func_177952_p() + zo);
                        if (!gen.apply(checkPos).booleanValue()) continue;
                        return true;
                    }
                    for (yo = 1; yo <= yUp; ++yo) {
                        checkPos.func_181079_c(center.func_177958_n() + xo, center.func_177956_o() + yo, center.func_177952_p() + zo);
                        if (!gen.apply(checkPos).booleanValue()) continue;
                        return true;
                    }
                    for (yo = 1; yo <= yDown; ++yo) {
                        checkPos.func_181079_c(center.func_177958_n() + xo, center.func_177956_o() - yo, center.func_177952_p() + zo);
                        if (!gen.apply(checkPos).booleanValue()) continue;
                        return true;
                    }
                }
            }
            if (xo == zo || xo < 0 && xo == -zo || xo > 0 && xo == 1 - zo) {
                int d0 = dir[0];
                dir[0] = -dir[1];
                dir[1] = d0;
            }
            xo += dir[0];
            zo += dir[1];
        }
        return false;
    }

    protected boolean canGeneratePortalTree(World world, BlockPos pos) {
        int height = 10;
        int maxRadius = 8;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int xo = -maxRadius; xo <= maxRadius; ++xo) {
            for (int zo = -maxRadius; zo <= maxRadius; ++zo) {
                if (!(Math.sqrt(xo * xo + zo * zo) <= (double)maxRadius)) continue;
                for (int yo = -3; yo < height; ++yo) {
                    checkPos.func_181079_c(pos.func_177958_n() + xo, pos.func_177956_o() + yo, pos.func_177952_p() + zo);
                    IBlockState blockState = world.func_180495_p((BlockPos)checkPos);
                    if ((yo < 2 || !blockState.func_185904_a().func_76224_d() && !blockState.func_185915_l()) && !(blockState.func_177230_c() instanceof BlockLeaves)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean canGenerateSmallPortalInOpen(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos p : BlockPos.func_191531_b((int)(pos.func_177958_n() - 3), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 3), (int)(pos.func_177958_n() + 3), (int)(pos.func_177956_o() + 7), (int)(pos.func_177952_p() + 3))) {
            boolean isOutside;
            IBlockState blockState = world.func_180495_p((BlockPos)p);
            boolean bl = isOutside = Math.abs(pos.func_177958_n() - p.func_177958_n()) >= 2 || Math.abs(pos.func_177952_p() - p.func_177952_p()) >= 2 || p.func_177956_o() - pos.func_177956_o() >= 5;
            if (!isOutside && (blockState.func_185904_a().func_76224_d() || blockState.func_185915_l() || blockState.func_177230_c() instanceof BlockLeaves)) {
                return false;
            }
            if (!isOutside || blockState.func_177230_c() != BlockRegistry.TREE_PORTAL) continue;
            return false;
        }
        return true;
    }

    protected boolean isSmallPortalObstructedByOthersOrLiquid(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos p : BlockPos.func_191531_b((int)(pos.func_177958_n() - 3), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 3), (int)(pos.func_177958_n() + 3), (int)(pos.func_177956_o() + 7), (int)(pos.func_177952_p() + 3))) {
            IBlockState blockState = world.func_180495_p((BlockPos)p);
            if (!blockState.func_185904_a().func_76224_d() && blockState.func_177230_c() != BlockRegistry.TREE_PORTAL) continue;
            return true;
        }
        return false;
    }

    public BlockPos setDefaultPlayerSpawnLocation(BlockPos portalPos, Entity entity) {
        if (!(entity instanceof EntityPlayerMP)) {
            return portalPos;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        BlockPos coords = player.getBedLocation(BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
        if (coords == null) {
            coords = PlayerRespawnHandler.getRespawnPointNearPos((World)this.toWorld, portalPos, 64);
            player.setSpawnChunk(coords, true, BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
        }
        if (this.toWorld.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            NBTTagCompound dataNbt = player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            persistentNbt.func_74772_a(LAST_PORTAL_POS_NBT, portalPos.func_177986_g());
            dataNbt.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
        }
        return coords;
    }

    protected void setEntityLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, yaw, pitch);
        } else {
            entity.func_70012_b(x, y, z, yaw, pitch);
        }
    }

    protected Chunk getDecoratedChunk(World world, BlockPos pos) {
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        int bx = pos.func_177958_n();
        int by = pos.func_177956_o();
        int bz = pos.func_177952_p();
        for (int xo = -16; xo <= 16; xo += 16) {
            for (int yo = -16; yo <= 16; yo += 16) {
                for (int zo = -16; zo <= 16; zo += 16) {
                    mutableBlockPos.func_181079_c(bx + xo, by + yo, bz + zo);
                    world.func_180495_p((BlockPos)mutableBlockPos);
                }
            }
        }
        mutableBlockPos.func_185344_t();
        return world.func_175726_f(pos);
    }

    public void func_85189_a(long timer) {
    }
}

