/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.layer;

import com.google.common.collect.Lists;
import java.util.List;

public class InstancedIntCache {
    private int intCacheSize = 256;
    private final List<int[]> freeSmallArrays = Lists.newArrayList();
    private final List<int[]> inUseSmallArrays = Lists.newArrayList();
    private final List<int[]> freeLargeArrays = Lists.newArrayList();
    private final List<int[]> inUseLargeArrays = Lists.newArrayList();

    public int[] getIntCache(int size) {
        if (size <= 256) {
            if (this.freeSmallArrays.isEmpty()) {
                int[] aint4 = new int[256];
                this.inUseSmallArrays.add(aint4);
                return aint4;
            }
            int[] aint3 = this.freeSmallArrays.remove(this.freeSmallArrays.size() - 1);
            this.inUseSmallArrays.add(aint3);
            return aint3;
        }
        if (size > this.intCacheSize) {
            this.intCacheSize = size;
            this.freeLargeArrays.clear();
            this.inUseLargeArrays.clear();
            int[] aint2 = new int[this.intCacheSize];
            this.inUseLargeArrays.add(aint2);
            return aint2;
        }
        if (this.freeLargeArrays.isEmpty()) {
            int[] aint1 = new int[this.intCacheSize];
            this.inUseLargeArrays.add(aint1);
            return aint1;
        }
        int[] aint = this.freeLargeArrays.remove(this.freeLargeArrays.size() - 1);
        this.inUseLargeArrays.add(aint);
        return aint;
    }

    public void resetIntCache() {
        if (!this.freeLargeArrays.isEmpty()) {
            this.freeLargeArrays.remove(this.freeLargeArrays.size() - 1);
        }
        if (!this.freeSmallArrays.isEmpty()) {
            this.freeSmallArrays.remove(this.freeSmallArrays.size() - 1);
        }
        this.freeLargeArrays.addAll(this.inUseLargeArrays);
        this.freeSmallArrays.addAll(this.inUseSmallArrays);
        this.inUseLargeArrays.clear();
        this.inUseSmallArrays.clear();
    }
}

