/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenTarPoolDungeon
extends WorldGenHelper {
    public static final ResourceLocation loot = LootTableRegistry.DUNGEON_POT_LOOT;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int zz;
        int height = 10;
        int halfSize = 7;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.func_175697_a(pos, halfSize + 1)) {
            return false;
        }
        if (y + height + 1 >= 120 - height || y - 1 <= 15 + height) {
            return false;
        }
        for (int xx = x - halfSize - 1; xx <= x + halfSize + 1; ++xx) {
            for (int yy = y - 1; yy <= y + height + 1; ++yy) {
                for (zz = z - halfSize - 1; zz <= z + halfSize + 1; ++zz) {
                    Material mat = world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)).func_185904_a();
                    if (yy != y - 1 && yy != y + height + 1 || mat.func_76220_a()) continue;
                    return false;
                }
            }
        }
        for (int x1 = x - halfSize; x1 <= x + halfSize; ++x1) {
            for (int z1 = z - halfSize; z1 <= z + halfSize; ++z1) {
                for (int y1 = y; y1 < y + height; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) > (long)halfSize || y1 < y + 3) continue;
                    world.func_175698_g(new BlockPos(x1, y1, z1));
                }
            }
        }
        for (int yy = y + 2; yy >= y; --yy) {
            for (int xx = halfSize * -1; xx <= halfSize; ++xx) {
                for (zz = halfSize * -1; zz <= halfSize; ++zz) {
                    double dSq = xx * xx + zz * zz;
                    if (Math.round(Math.sqrt(dSq)) == (long)(halfSize - 2) && yy >= y + 1) {
                        world.func_175656_a(new BlockPos(x + xx, yy, z + zz), BlockRegistry.BETWEENSTONE_TILES.func_176223_P());
                        if (rand.nextBoolean() && yy == y + 2 && (xx % 4 == 0 || zz % 4 == 0 || xx % 3 == 0 || zz % 3 == 0) && world.func_180495_p((BlockPos)this.getCheckPos(x + xx, y + 6, z + zz)).func_177230_c() == BlockRegistry.BETWEENSTONE) {
                            this.placePillar(world, x + xx, y + 3, z + zz, rand);
                        }
                    }
                    if (Math.round(Math.sqrt(dSq)) <= (long)halfSize && Math.round(Math.sqrt(dSq)) >= (long)(halfSize - 1) && yy <= y + 2) {
                        world.func_175656_a(new BlockPos(x + xx, yy, z + zz), BlockRegistry.BETWEENSTONE.func_176223_P());
                    }
                    if (Math.round(Math.sqrt(dSq)) < (long)(halfSize - 2) && yy >= y + 1) {
                        world.func_175656_a(new BlockPos(x + xx, yy, z + zz), BlockRegistry.TAR.func_176223_P());
                    }
                    if (Math.round(Math.sqrt(dSq)) >= (long)(halfSize - 2) || yy != y) continue;
                    if (rand.nextBoolean() && rand.nextBoolean()) {
                        world.func_175656_a(new BlockPos(x + xx, yy, z + zz), BlockRegistry.TAR_SOLID.func_176223_P());
                    } else {
                        world.func_175656_a(new BlockPos(x + xx, yy, z + zz), BlockRegistry.BETWEENSTONE.func_176223_P());
                    }
                    if (rand.nextInt(18) != 0) continue;
                    world.func_175656_a(new BlockPos(x + xx, yy, z + zz), this.getRandomTarLootPot(rand).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.field_176754_o[rand.nextInt(4)]));
                    TileEntity te = world.func_175625_s((BlockPos)this.getCheckPos(x + xx, yy, z + zz));
                    if (!(te instanceof TileEntityLootPot)) continue;
                    ((TileEntityLootPot)te).setLootTable(loot, rand.nextLong());
                }
            }
        }
        world.func_175656_a(new BlockPos(x + rand.nextInt(halfSize - 2) - rand.nextInt(halfSize - 2), y, z + rand.nextInt(halfSize - 2) - rand.nextInt(halfSize - 2)), BlockRegistry.TAR_BEAST_SPAWNER.func_176223_P());
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationStorage location = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "tar_pool_dungeon", EnumLocationType.DUNGEON);
        location.addBounds(new AxisAlignedBB((double)(x - halfSize), (double)(y - 1), (double)(z - halfSize), (double)(x + halfSize), (double)(y + height), (double)(z + halfSize)).func_72314_b(1.0, 1.0, 1.0));
        location.linkChunks();
        location.setLayer(0);
        location.setSeed(rand.nextLong());
        location.setVisible(true);
        location.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(location);
        return true;
    }

    private void placePillar(World world, int x, int y, int z, Random rand) {
        int randHeight = rand.nextInt(3);
        for (int yy = y; randHeight + y >= yy; ++yy) {
            world.func_175656_a(new BlockPos(x, yy, z), BlockRegistry.BETWEENSTONE_BRICK_WALL.func_176223_P());
        }
    }

    private IBlockState getRandomTarLootPot(Random rand) {
        switch (rand.nextInt(3)) {
            default: {
                return BlockRegistry.TAR_LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1));
            }
            case 1: {
                return BlockRegistry.TAR_LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2));
            }
            case 2: 
        }
        return BlockRegistry.TAR_LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3));
    }
}

