/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.structure.BlockMobSpawnerBetweenlands;
import thebetweenlands.common.block.structure.BlockStairsBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenSpawnerStructure
extends WorldGenerator {
    public boolean func_180709_b(World world, Random random, BlockPos position) {
        return this.generateStructure1(world, random, position);
    }

    public boolean generateStructure1(World world, Random random, BlockPos pos) {
        int yy;
        int zz;
        int xx;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int surfaceBlocks = 0;
        for (xx = x; xx < x + 5; ++xx) {
            for (zz = z; zz < z + 5; ++zz) {
                for (yy = y; yy < y + 5; ++yy) {
                    if (yy == y && SurfaceType.MIXED_GROUND.matches(world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, y - 1, zz)))) {
                        ++surfaceBlocks;
                    }
                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(xx, yy, zz)) || world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos.func_181079_c(xx, yy, zz))) continue;
                    return false;
                }
                for (yy = y; yy >= y - 5 && (world.func_175623_d((BlockPos)checkPos.func_181079_c(xx, yy, zz)) || world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos.func_181079_c(xx, yy, zz))); --yy) {
                    if (yy > y - 5) continue;
                    return false;
                }
            }
        }
        if (surfaceBlocks < 8) {
            return false;
        }
        for (xx = x; xx < x + 5; ++xx) {
            for (zz = z; zz < z + 5; ++zz) {
                for (yy = y; yy >= y - 5 && (world.func_175623_d((BlockPos)checkPos.func_181079_c(xx, yy, zz)) || world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos.func_181079_c(xx, yy, zz))); --yy) {
                    world.func_180501_a(new BlockPos(xx, yy, zz), BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P(), 2);
                }
            }
        }
        for (int yy2 = y; yy2 < y + 5; ++yy2) {
            int xx2;
            if (yy2 == y) {
                world.func_180501_a(new BlockPos(x, yy2, z), BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x + 4, yy2, z), BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x + 4, yy2, z + 4), BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x, yy2, z + 4), BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P(), 2);
                for (xx2 = x + 1; xx2 < x + 4; ++xx2) {
                    world.func_180501_a(new BlockPos(xx2, yy2, z), BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH), 2);
                    world.func_180501_a(new BlockPos(xx2, yy2, z + 4), BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH), 2);
                }
                for (zz = z + 1; zz < z + 4; ++zz) {
                    world.func_180501_a(new BlockPos(x, yy2, zz), BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST), 2);
                    world.func_180501_a(new BlockPos(x + 1, yy2, zz), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                    if (zz != z + 2) {
                        world.func_180501_a(new BlockPos(x + 2, yy2, zz), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                    } else {
                        world.func_180501_a(new BlockPos(x + 2, yy2, zz), BlockRegistry.BETWEENSTONE_CHISELED.func_176223_P(), 2);
                        world.func_180501_a(new BlockPos(x + 2, yy2 + 2, zz), BlockRegistry.MOB_SPAWNER.func_176223_P(), 2);
                        MobSpawnerLogicBetweenlands logic = BlockMobSpawnerBetweenlands.setRandomMob(world, new BlockPos(x + 2, yy2 + 2, zz), random, new Consumer[0]);
                        if (logic != null) {
                            logic.setSpawnInAir(false);
                        }
                    }
                    world.func_180501_a(new BlockPos(x + 3, yy2, zz), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x + 4, yy2, zz), BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST), 2);
                }
                int randomInt = random.nextInt(4);
                switch (randomInt) {
                    case 0: {
                        world.func_180501_a(new BlockPos(x + 1, yy2 + 1, z + 1), BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), 2);
                        TileEntity tile = world.func_175625_s(new BlockPos(x + 1, yy2 + 1, z + 1));
                        if (!(tile instanceof TileEntityChest)) break;
                        ((TileEntityChest)tile).func_189404_a(LootTableRegistry.DUNGEON_CHEST_LOOT, random.nextLong());
                        break;
                    }
                    case 1: {
                        world.func_180501_a(new BlockPos(x + 1, yy2 + 1, z + 3), BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), 2);
                        TileEntity tile = world.func_175625_s(new BlockPos(x + 1, yy2 + 1, z + 3));
                        if (!(tile instanceof TileEntityChest)) break;
                        ((TileEntityChest)tile).func_189404_a(LootTableRegistry.DUNGEON_CHEST_LOOT, random.nextLong());
                        break;
                    }
                    case 2: {
                        world.func_180501_a(new BlockPos(x + 3, yy2 + 1, z + 1), BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), 2);
                        TileEntity tile = world.func_175625_s(new BlockPos(x + 3, yy2 + 1, z + 1));
                        if (!(tile instanceof TileEntityChest)) break;
                        ((TileEntityChest)tile).func_189404_a(LootTableRegistry.DUNGEON_CHEST_LOOT, random.nextLong());
                        break;
                    }
                    case 3: {
                        world.func_180501_a(new BlockPos(x + 3, yy2 + 1, z + 3), BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), 2);
                        TileEntity tile = world.func_175625_s(new BlockPos(x + 3, yy2 + 1, z + 3));
                        if (!(tile instanceof TileEntityChest)) break;
                        ((TileEntityChest)tile).func_189404_a(LootTableRegistry.DUNGEON_CHEST_LOOT, random.nextLong());
                    }
                }
                continue;
            }
            if (yy2 < y + 4) {
                world.func_180501_a(new BlockPos(x, yy2, z), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x + 4, yy2, z), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x + 4, yy2, z + 4), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x, yy2, z + 4), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                continue;
            }
            world.func_180501_a(new BlockPos(x, yy2, z), BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x + 4, yy2, z), BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x + 4, yy2, z + 4), BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x, yy2, z + 4), BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P(), 2);
            for (xx2 = x + 1; xx2 < x + 4; ++xx2) {
                world.func_180501_a(new BlockPos(xx2, yy2, z), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(xx2, yy2, z + 4), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
            }
            for (zz = z + 1; zz < z + 4; ++zz) {
                world.func_180501_a(new BlockPos(x, yy2, zz), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x + 4, yy2, zz), BlockRegistry.BETWEENSTONE_TILES.func_176223_P(), 2);
            }
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationStorage location = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(x, z), "small_dungeon", EnumLocationType.DUNGEON);
        location.addBounds(new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 5), (double)(y + 5), (double)(z + 5)).func_72314_b(2.0, 2.0, 2.0));
        location.linkChunks();
        location.setLayer(0);
        location.setSeed(random.nextLong());
        location.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(location);
        return true;
    }
}

