/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning.spawners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.entity.mobs.EntityGreebling;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;

public class GreeblingSpawnEntry
extends SurfaceSpawnEntry {
    private EnumFacing facing = EnumFacing.NORTH;

    public GreeblingSpawnEntry(int id, short weight) {
        super(id, EntityGreebling.class, weight);
    }

    @Override
    public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState spawnBlockState, IBlockState surfaceBlockState) {
        if (super.canSpawn(world, chunk, pos, spawnBlockState, surfaceBlockState)) {
            ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>(4);
            facings.addAll(Arrays.asList(EnumFacing.field_176754_o));
            Collections.shuffle(facings, world.field_73012_v);
            for (EnumFacing facing : facings) {
                BlockPos offset = pos.func_177972_a(facing);
                if (!world.func_175667_e(offset) || !world.func_175623_d(offset) || !world.func_175623_d(offset.func_177977_b())) continue;
                this.facing = facing;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onSpawned(EntityLivingBase entity) {
        EntityGreebling greebling = (EntityGreebling)entity;
        greebling.setFacing(this.facing);
    }
}

